/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.utils;

import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.querybuilder.BindMarker;
import com.datastax.oss.driver.api.querybuilder.Literal;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.ColumnRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.exactpro.cradle.cassandra.CassandraCradleStorage;
import com.exactpro.cradle.filters.ComparisonOperation;
import com.exactpro.cradle.filters.FilterByField;
import java.time.Instant;
import java.time.LocalDateTime;

public class FilterUtils {
    public static Select filterToWhere(FilterByField<?> filter, ColumnRelationBuilder<Select> column) {
        return FilterUtils.filterToWhere(filter.getValue(), filter.getOperation(), column);
    }

    public static Select filterToWhere(ComparisonOperation operation, ColumnRelationBuilder<Select> column, String bindMarkerName) {
        BindMarker bm = bindMarkerName != null ? QueryBuilder.bindMarker((String)bindMarkerName) : QueryBuilder.bindMarker();
        switch (operation) {
            case LESS: {
                return (Select)column.isLessThan((Term)bm);
            }
            case LESS_OR_EQUALS: {
                return (Select)column.isLessThanOrEqualTo((Term)bm);
            }
            case GREATER: {
                return (Select)column.isGreaterThan((Term)bm);
            }
            case GREATER_OR_EQUALS: {
                return (Select)column.isGreaterThanOrEqualTo((Term)bm);
            }
        }
        return (Select)column.isEqualTo((Term)bm);
    }

    public static Select filterToWhere(Object value, ComparisonOperation operation, ColumnRelationBuilder<Select> column) {
        Literal v = QueryBuilder.literal((Object)value);
        switch (operation) {
            case LESS: {
                return (Select)column.isLessThan((Term)v);
            }
            case LESS_OR_EQUALS: {
                return (Select)column.isLessThanOrEqualTo((Term)v);
            }
            case GREATER: {
                return (Select)column.isGreaterThan((Term)v);
            }
            case GREATER_OR_EQUALS: {
                return (Select)column.isGreaterThanOrEqualTo((Term)v);
            }
        }
        return (Select)column.isEqualTo((Term)v);
    }

    public static Select timestampFilterToWhere(FilterByField<Instant> filter, Select select, String dateColumn, String timeColumn) {
        LocalDateTime ldt = LocalDateTime.ofInstant((Instant)filter.getValue(), CassandraCradleStorage.TIMEZONE_OFFSET);
        Select result = FilterUtils.filterToWhere(ldt.toLocalDate(), filter.getOperation(), (ColumnRelationBuilder<Select>)select.whereColumn(dateColumn));
        result = FilterUtils.filterToWhere(ldt.toLocalTime(), filter.getOperation(), (ColumnRelationBuilder<Select>)result.whereColumn(timeColumn));
        return result;
    }

    public static BoundStatementBuilder bindTimestamp(Instant timestamp, BoundStatementBuilder builder, String dateColumn, String timeColumn) {
        LocalDateTime ldt = LocalDateTime.ofInstant(timestamp, CassandraCradleStorage.TIMEZONE_OFFSET);
        builder = (BoundStatementBuilder)builder.setLocalDate(dateColumn, ldt.toLocalDate());
        builder = (BoundStatementBuilder)builder.setLocalTime(timeColumn, ldt.toLocalTime());
        return builder;
    }
}

