/*
 * Decompiled with CFR 0.152.
 */
package com.exacttarget.fuelsdk;

import com.exacttarget.fuelsdk.ETClient;
import com.exacttarget.fuelsdk.ETSdkException;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.apache.log4j.Logger;

public class ETRestConnection {
    private static Logger logger = Logger.getLogger(ETRestConnection.class);
    private ETClient client = null;
    private String endpoint = null;
    private boolean isAuthConnection = false;
    private static final int URL_MAX_LENGTH = 2048;

    public ETRestConnection(ETClient client, String endpoint) throws ETSdkException {
        this(client, endpoint, false);
    }

    public ETRestConnection(ETClient client, String endpoint, boolean isAuthConnection) throws ETSdkException {
        this.client = client;
        this.endpoint = endpoint;
        this.isAuthConnection = isAuthConnection;
    }

    public Response get(String path) throws ETSdkException {
        Response response = new Response();
        HttpURLConnection connection = this.sendRequest(path, Method.GET);
        String json = this.receiveResponse(connection);
        response.setRequestId(connection.getHeaderField("X-Mashery-Message-ID"));
        try {
            response.setResponseCode(connection.getResponseCode());
            response.setResponseMessage(connection.getResponseMessage());
        }
        catch (IOException ex) {
            throw new ETSdkException(ex);
        }
        response.setResponsePayload(json);
        connection.disconnect();
        return response;
    }

    public Response post(String path, String payload) throws ETSdkException {
        Response response = new Response();
        HttpURLConnection connection = this.sendRequest(path, Method.POST, payload);
        String json = this.receiveResponse(connection);
        response.setRequestId(connection.getHeaderField("X-Mashery-Message-ID"));
        try {
            response.setResponseCode(connection.getResponseCode());
            response.setResponseMessage(connection.getResponseMessage());
        }
        catch (IOException ex) {
            throw new ETSdkException(ex);
        }
        response.setResponsePayload(json);
        connection.disconnect();
        return response;
    }

    public Response patch(String path, String payload) throws ETSdkException {
        Response response = new Response();
        HttpURLConnection connection = this.sendRequest(path, Method.PATCH, payload);
        String json = this.receiveResponse(connection);
        response.setRequestId(connection.getHeaderField("X-Mashery-Message-ID"));
        try {
            response.setResponseCode(connection.getResponseCode());
            response.setResponseMessage(connection.getResponseMessage());
        }
        catch (IOException ex) {
            throw new ETSdkException(ex);
        }
        response.setResponsePayload(json);
        connection.disconnect();
        return response;
    }

    public Response delete(String path) throws ETSdkException {
        Response response = new Response();
        HttpURLConnection connection = this.sendRequest(path, Method.DELETE);
        String json = this.receiveResponse(connection);
        response.setRequestId(connection.getHeaderField("X-Mashery-Message-ID"));
        try {
            response.setResponseCode(connection.getResponseCode());
            response.setResponseMessage(connection.getResponseMessage());
        }
        catch (IOException ex) {
            throw new ETSdkException(ex);
        }
        response.setResponsePayload(json);
        connection.disconnect();
        return response;
    }

    private HttpURLConnection sendRequest(String path, Method method) throws ETSdkException {
        if (path.length() > 2048) {
            throw new ETSdkException(path + ": URL too long");
        }
        return this.sendRequest(path, method, null);
    }

    private HttpURLConnection sendRequest(String path, Method method, String payload) throws ETSdkException {
        URL url = null;
        try {
            url = new URL(this.endpoint + path);
        }
        catch (MalformedURLException ex) {
            throw new ETSdkException(this.endpoint + path + ": bad URL", ex);
        }
        return this.sendRequest(url, method, payload);
    }

    private HttpURLConnection sendRequest(URL url, Method method, String payload) throws ETSdkException {
        Gson gson = this.client.getGson();
        logger.debug((Object)((Object)((Object)method) + " " + url));
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(method.toString());
        }
        catch (ProtocolException ex) {
            throw new ETSdkException("error setting request method: " + method.toString(), ex);
        }
        catch (IOException ex) {
            throw new ETSdkException("error opening " + url, ex);
        }
        switch (method) {
            case GET: {
                connection.setDoInput(true);
                connection.setRequestProperty("Accept", "application/json");
                break;
            }
            case POST: 
            case PATCH: 
            case DELETE: {
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", "application/json");
                break;
            }
            default: {
                throw new ETSdkException("unsupported request method: " + method.toString());
            }
        }
        if (!this.isAuthConnection) {
            connection.setRequestProperty("Authorization", "Bearer " + this.client.refreshToken());
        }
        if (logger.isDebugEnabled()) {
            for (String key : connection.getRequestProperties().keySet()) {
                logger.debug((Object)(key + ": " + connection.getRequestProperty(key)));
            }
        }
        if (payload != null) {
            if (logger.isDebugEnabled()) {
                JsonParser jsonParser = new JsonParser();
                String payloadPrettyPrinted = gson.toJson(jsonParser.parse(payload));
                for (String line : payloadPrettyPrinted.split("\\n")) {
                    logger.debug((Object)line);
                }
            }
            try {
                OutputStream os = connection.getOutputStream();
                os.write(payload.getBytes());
                os.flush();
            }
            catch (IOException ex) {
                throw new ETSdkException("error writing " + url, ex);
            }
        }
        try {
            logger.debug((Object)(connection.getResponseCode() + " " + connection.getResponseMessage()));
        }
        catch (IOException ex) {
            throw new ETSdkException("error getting response code / message", ex);
        }
        return connection;
    }

    private String receiveResponse(HttpURLConnection connection) throws ETSdkException {
        Gson gson = this.client.getGson();
        InputStream is = null;
        try {
            is = connection.getResponseCode() < 400 ? connection.getInputStream() : connection.getErrorStream();
        }
        catch (IOException ex) {
            throw new ETSdkException("error opening " + connection.getURL(), ex);
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException ex) {
            throw new ETSdkException("error reading " + connection.getURL(), ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                throw new ETSdkException("error closing " + connection.getURL(), ex);
            }
        }
        String response = stringBuilder.toString();
        if (logger.isDebugEnabled()) {
            JsonParser jsonParser = new JsonParser();
            String responsePrettyPrinted = gson.toJson(jsonParser.parse(response));
            for (String line : responsePrettyPrinted.split("\\n")) {
                logger.debug((Object)line);
            }
        }
        return response;
    }

    public class Response {
        private String requestId = null;
        private Integer responseCode = null;
        private String responseMessage = null;
        private String responsePayload = null;

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public Integer getResponseCode() {
            return this.responseCode;
        }

        public void setResponseCode(Integer responseCode) {
            this.responseCode = responseCode;
        }

        public String getResponseMessage() {
            return this.responseMessage;
        }

        public void setResponseMessage(String responseMessage) {
            this.responseMessage = responseMessage;
        }

        public String getResponsePayload() {
            return this.responsePayload;
        }

        public void setResponsePayload(String responsePayload) {
            this.responsePayload = responsePayload;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        GET,
        POST,
        PATCH,
        DELETE;

    }
}

