/*
 * Decompiled with CFR 0.152.
 */
package com.exacttarget.fuelsdk;

import com.exacttarget.fuelsdk.ETClient;
import com.exacttarget.fuelsdk.ETEmail;
import com.exacttarget.fuelsdk.ETObject;
import com.exacttarget.fuelsdk.ETSoapObject;
import com.exacttarget.fuelsdk.annotations.ExternalName;
import com.exacttarget.fuelsdk.annotations.InternalName;
import com.exacttarget.fuelsdk.annotations.SoapObject;
import com.exacttarget.fuelsdk.internal.APIObject;
import com.exacttarget.fuelsdk.internal.ListSubscriber;
import com.exacttarget.fuelsdk.internal.RetrieveRequest;
import com.exacttarget.fuelsdk.internal.RetrieveRequestMsg;
import com.exacttarget.fuelsdk.internal.RetrieveResponseMsg;
import com.exacttarget.fuelsdk.internal.SimpleFilterPart;
import com.exacttarget.fuelsdk.internal.SimpleOperators;
import com.exacttarget.fuelsdk.internal.Soap;
import com.exacttarget.fuelsdk.internal.Subscriber;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SoapObject(internalType=Subscriber.class, unretrievable={"Attributes", "ModifiedDate"})
public class ETSubscriber
extends ETSoapObject {
    @ExternalName(value="id")
    private String id = null;
    @ExternalName(value="key")
    @InternalName(value="subscriberKey")
    private String key = null;
    @ExternalName(value="createdDate")
    private Date createdDate = null;
    @ExternalName(value="modifiedDate")
    private Date modifiedDate = null;
    @ExternalName(value="emailAddress")
    private String emailAddress = null;
    @ExternalName(value="preferredEmailType")
    @InternalName(value="emailTypePreference")
    private ETEmail.Type preferredEmailType = null;
    @ExternalName(value="status")
    private Status status = null;
    @ExternalName(value="unsubscribedDate")
    private Date unsubscribedDate = null;
    private List<Subscription> subscriptions = new ArrayList<Subscription>();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public ETEmail.Type getPreferredEmailType() {
        return this.preferredEmailType;
    }

    public void setPreferredEmailType(ETEmail.Type preferredEmailType) {
        this.preferredEmailType = preferredEmailType;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Date getUnsubscribedDate() {
        return this.unsubscribedDate;
    }

    public void setUnsubscribedDate(Date unsubscribedDate) {
        this.unsubscribedDate = unsubscribedDate;
    }

    public List<Subscription> getSubscriptions() {
        ETClient client = this.getClient();
        if (client.autoHydrateObjects().booleanValue()) {
            this.retrieveSubscriptions();
        }
        return this.subscriptions;
    }

    public void retrieveSubscriptions() {
        ETClient client = this.getClient();
        Soap soap = client.getSoapConnection().getSoap();
        SimpleFilterPart filter = new SimpleFilterPart();
        filter.setProperty("ID");
        filter.setSimpleOperator(SimpleOperators.EQUALS);
        filter.getValue().add(this.id);
        RetrieveRequest retrieveRequest = new RetrieveRequest();
        retrieveRequest.setObjectType("ListSubscriber");
        retrieveRequest.getProperties().add("ListID");
        retrieveRequest.getProperties().add("SubscriberKey");
        retrieveRequest.getProperties().add("Status");
        retrieveRequest.setFilter(filter);
        RetrieveRequestMsg retrieveRequestMsg = new RetrieveRequestMsg();
        retrieveRequestMsg.setRetrieveRequest(retrieveRequest);
        RetrieveResponseMsg retrieveResponseMsg = soap.retrieve(retrieveRequestMsg);
        this.subscriptions = new ArrayList<Subscription>();
        for (APIObject apiObject : retrieveResponseMsg.getResults()) {
            ListSubscriber listSubscriber = (ListSubscriber)apiObject;
            Subscription subscription = new Subscription();
            subscription.setListId(listSubscriber.getListID().toString());
            subscription.setStatus(Status.fromValue(listSubscriber.getStatus().value()));
            this.subscriptions.add(subscription);
        }
    }

    @Deprecated
    public String getSubscriberKey() {
        return this.getKey();
    }

    @Deprecated
    public void setSubscriberKey(String subscriberKey) {
        this.setKey(subscriberKey);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ACTIVE("Active"),
        BOUNCED("Bounced"),
        DELETED("Deleted"),
        HELD("Held"),
        UNSUBSCRIBED("Unsubscribed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static Status fromValue(String value) {
            for (Status v : Status.values()) {
                if (!v.value.equals(value)) continue;
                return v;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public class Subscription
    extends ETObject {
        @ExternalName(value="listId")
        private String listId = null;
        @ExternalName(value="status")
        private Status status = null;

        public String getListId() {
            return this.listId;
        }

        public void setListId(String listId) {
            this.listId = listId;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }
    }
}

