/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.adapters;

import com.exadel.aem.toolkit.api.handlers.Adapts;
import com.exadel.aem.toolkit.plugin.exceptions.ReflectionException;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;

public abstract class AdaptationBase<T> {
    private static final String ADAPTER_EXCEPTION_MESSAGE = "Could not create an adapter for ";
    private final Class<T> reflectedClass;
    private Map<Class<?>, Object> adaptations;

    protected AdaptationBase(Class<T> reflectedClass) {
        this.reflectedClass = reflectedClass;
    }

    public <A> A adaptTo(Class<A> type) {
        if (ClassUtils.isAssignable(this.getClass(), type)) {
            return type.cast(this);
        }
        A cachedAdaptation = this.getAdaptation(type);
        if (cachedAdaptation != null) {
            return cachedAdaptation;
        }
        if (type.isAnnotationPresent(Adapts.class) && this.reflectedClass.equals(type.getAnnotation(Adapts.class).value())) {
            try {
                A value = type.getConstructor(this.reflectedClass).newInstance(this);
                this.storeAdaptation(type, value);
                return type.cast(value);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                ReflectionException re = new ReflectionException(ADAPTER_EXCEPTION_MESSAGE + type.getName(), e);
                PluginRuntime.context().getExceptionHandler().handle((Exception)re);
            }
        }
        return null;
    }

    public boolean hasAdaptation(Class<?> adaptation) {
        if (ClassUtils.isAssignable(this.getClass(), adaptation)) {
            return true;
        }
        return this.getAdaptation(adaptation) != null;
    }

    private <A> A getAdaptation(Class<A> type) {
        if (this.adaptations != null && this.adaptations.containsKey(type)) {
            return type.cast(this.adaptations.get(type));
        }
        return null;
    }

    private void storeAdaptation(Class<?> type, Object value) {
        if (this.adaptations == null) {
            this.adaptations = new HashMap();
        }
        this.adaptations.put(type, value);
    }
}

