/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.adapters;

import com.exadel.aem.toolkit.api.annotations.main.ClassField;
import com.exadel.aem.toolkit.api.annotations.main.ClassMember;
import com.exadel.aem.toolkit.api.handlers.MemberSource;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.markers._Default;
import com.exadel.aem.toolkit.api.markers._Super;
import org.apache.commons.lang3.StringUtils;

public class ClassMemberSetting {
    private ClassMember wrappedClassMember;
    private ClassField wrappedClassField;
    private Class<?> overridingSource;
    private String overridingName;

    public ClassMemberSetting(ClassMember value) {
        this.wrappedClassMember = value;
    }

    public ClassMemberSetting(ClassField value) {
        this.wrappedClassField = value;
    }

    public Class<?> getSource() {
        if (this.overridingSource != null) {
            return this.overridingSource;
        }
        if (this.wrappedClassMember != null) {
            return this.wrappedClassMember.source();
        }
        return this.wrappedClassField != null ? this.wrappedClassField.source() : _Default.class;
    }

    public String getName() {
        if (StringUtils.isNotBlank((CharSequence)this.overridingName)) {
            return this.overridingName;
        }
        if (this.wrappedClassMember != null) {
            return this.wrappedClassMember.value();
        }
        return this.wrappedClassField != null ? this.wrappedClassField.field() : "";
    }

    public ClassMemberSetting populateDefaults(Class<?> source) {
        return this.populateDefaults(source, null);
    }

    public ClassMemberSetting populateDefaults(Class<?> source, String name) {
        if (this.overridingSource == null && this.getSource().equals(_Default.class)) {
            this.overridingSource = source;
        } else if (this.overridingSource == null && this.getSource().equals(_Super.class)) {
            Class<?> clazz = this.overridingSource = source.getSuperclass() != null ? source.getSuperclass() : source;
        }
        if (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isBlank((CharSequence)this.getName())) {
            this.overridingName = name;
        }
        return this;
    }

    public boolean matches(Source source) {
        return this.getSource().equals(((MemberSource)source.adaptTo(MemberSource.class)).getDeclaringClass()) && this.getName().equals(source.getName());
    }
}

