/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.adapters;

import com.exadel.aem.toolkit.api.annotations.widgets.datepicker.DateTimeValue;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import org.apache.commons.lang3.StringUtils;

public class DateTimeSetting {
    private final DateTimeValue dateTimeValue;
    private Temporal dateTimeInstance;

    public DateTimeSetting(DateTimeValue dateTimeValue) {
        this.dateTimeValue = dateTimeValue;
    }

    public boolean isValid() {
        return this.dateTimeValue != null && (this.isEmpty() || this.getTemporal() != null);
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.dateTimeValue.timezone()) && this.dateTimeValue.minute() == 0 && this.dateTimeValue.hour() == 0 && this.dateTimeValue.day() == 0 && this.dateTimeValue.month() == 0 && this.dateTimeValue.year() == 0;
    }

    public Temporal getTemporal() {
        if (this.dateTimeInstance != null) {
            return this.dateTimeInstance;
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)this.dateTimeValue.timezone())) {
                return ZonedDateTime.of(this.dateTimeValue.year(), this.dateTimeValue.month(), this.dateTimeValue.day(), this.dateTimeValue.hour(), this.dateTimeValue.minute(), 0, 0, ZoneId.of(this.dateTimeValue.timezone()));
            }
            this.dateTimeInstance = LocalDateTime.of(this.dateTimeValue.year(), this.dateTimeValue.month(), this.dateTimeValue.day(), this.dateTimeValue.hour(), this.dateTimeValue.minute());
        }
        catch (DateTimeException e) {
            this.dateTimeInstance = null;
        }
        return this.dateTimeInstance;
    }
}

