/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.adapters;

import com.exadel.aem.toolkit.api.handlers.Adapts;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.utils.NamingUtil;
import com.exadel.aem.toolkit.plugin.utils.XmlFactory;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Adapts(value=Target.class)
public class DomAdapter {
    private final Target target;

    public DomAdapter(Target target) {
        this.target = target;
    }

    public Document composeDocument(Document sourceDocument) {
        if (this.target == null) {
            return sourceDocument;
        }
        if (sourceDocument == null) {
            try {
                sourceDocument = XmlFactory.newDocument();
            }
            catch (ParserConfigurationException e) {
                PluginRuntime.context().getExceptionHandler().handle((Exception)e);
                return null;
            }
        }
        sourceDocument.appendChild(DomAdapter.createElement(sourceDocument, this.target, true));
        return sourceDocument;
    }

    public Element composeElement(Document sourceDocument) {
        if (this.target == null) {
            return sourceDocument != null ? sourceDocument.getDocumentElement() : null;
        }
        if (sourceDocument == null) {
            try {
                sourceDocument = XmlFactory.newDocument();
            }
            catch (ParserConfigurationException e) {
                PluginRuntime.context().getExceptionHandler().handle((Exception)e);
                return null;
            }
        }
        return DomAdapter.createElement(sourceDocument, this.target, true);
    }

    private static Element createElement(Document sourceDocument, Target target, boolean isRoot) {
        String name = NamingUtil.getValidNodeName(target.getName());
        Element element = sourceDocument.createElement(name);
        for (Map.Entry entry : target.getAttributes().entrySet()) {
            element.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        target.getChildren().forEach(child -> element.appendChild(DomAdapter.createElement(sourceDocument, child, false)));
        if (isRoot) {
            XmlFactory.XML_NAMESPACES.forEach((key, value) -> element.setAttribute("xmlns:" + key, (String)value));
        }
        return element;
    }
}

