/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.adapters;

import com.exadel.aem.toolkit.api.annotations.meta.PropertyRendering;
import com.exadel.aem.toolkit.api.annotations.meta.ResourceType;
import com.exadel.aem.toolkit.api.handlers.Adapts;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import com.exadel.aem.toolkit.plugin.metadata.Property;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@Adapts(value=Source.class)
public class ResourceTypeSetting {
    private final Source wrappedSource;

    public ResourceTypeSetting(Source source) {
        this.wrappedSource = source;
    }

    public String getValue() {
        if (this.wrappedSource == null) {
            return "";
        }
        Object[] annotations = (Annotation[])this.wrappedSource.adaptTo(Annotation[].class);
        if (ArrayUtils.isEmpty((Object[])annotations)) {
            return "";
        }
        String resourceTypeValue = ResourceTypeSetting.getValueByResourceTypeAnnotation((Annotation[])annotations);
        if (resourceTypeValue != null) {
            return resourceTypeValue;
        }
        resourceTypeValue = ResourceTypeSetting.getValueByAnnotationProperty((Annotation[])annotations);
        return StringUtils.defaultString((String)resourceTypeValue);
    }

    private static String getValueByResourceTypeAnnotation(Annotation[] annotations) {
        return Arrays.stream(annotations).map(annotation -> Metadata.from(annotation).getAnnotation(ResourceType.class)).filter(Objects::nonNull).map(ResourceType::value).findFirst().orElse(null);
    }

    private static String getValueByAnnotationProperty(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Property property = Metadata.from(annotation).stream(false, false).filter(prop -> prop.getAnnotation(PropertyRendering.class) != null).findFirst().orElse(null);
            if (property == null) continue;
            return property.getValue() != null ? property.getValue().toString() : null;
        }
        return null;
    }
}

