/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.exceptions.handlers;

import com.exadel.aem.toolkit.plugin.exceptions.PluginException;
import com.exadel.aem.toolkit.plugin.exceptions.handlers.PermissiveExceptionHandler;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;

class SelectiveExceptionHandler
extends PermissiveExceptionHandler {
    private static final String PACKAGE_POSTFIX = ".*";
    private final List<String> exceptionTokens;

    SelectiveExceptionHandler(List<String> exceptionTokens) {
        this.exceptionTokens = exceptionTokens;
    }

    @Override
    public void handle(String message, Exception cause) {
        if (this.shouldTerminateOn(cause.getClass())) {
            throw new PluginException(message, cause);
        }
        super.handle(message, cause);
    }

    @Override
    public boolean shouldTerminateOn(Class<? extends Exception> exceptionType) {
        for (String exceptionToken : this.exceptionTokens) {
            Optional<Boolean> result = this.isMatch(exceptionType, StringUtils.strip((String)exceptionToken, (String)"!"), exceptionToken.startsWith("!"));
            if (!result.isPresent()) continue;
            return result.get();
        }
        return false;
    }

    private Optional<Boolean> isMatch(Class<? extends Exception> exceptionType, String exceptionToken, boolean inverse) {
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)exceptionToken, (CharSequence[])new CharSequence[]{"all", "*"})) {
            return !inverse ? Optional.of(true) : Optional.empty();
        }
        if (exceptionToken.endsWith(PACKAGE_POSTFIX)) {
            if (exceptionType.getName().startsWith(StringUtils.strip((String)exceptionToken, (String)PACKAGE_POSTFIX))) {
                return Optional.of(!inverse);
            }
            return Optional.empty();
        }
        if (exceptionType.getPackage().equals(PluginException.class.getPackage()) && exceptionToken.equals(exceptionType.getSimpleName())) {
            return Optional.of(!inverse);
        }
        try {
            Class<?> managedClass = Class.forName(exceptionToken);
            if (ClassUtils.isAssignable(exceptionType, managedClass)) {
                return Optional.of(!inverse);
            }
        }
        catch (ClassNotFoundException exception) {
            LOG.warn("Could not recognize exception class: {}", (Object)exceptionToken);
        }
        return Optional.empty();
    }
}

