/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers;

import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.handlers.common.AllowedChildrenHandler;
import com.exadel.aem.toolkit.plugin.handlers.common.CasualAnnotationsHandler;
import com.exadel.aem.toolkit.plugin.handlers.common.ComponentHandler;
import com.exadel.aem.toolkit.plugin.handlers.common.CqChildEditConfigHandler;
import com.exadel.aem.toolkit.plugin.handlers.common.CqDialogHandler;
import com.exadel.aem.toolkit.plugin.handlers.common.CqEditConfigHandler;
import com.exadel.aem.toolkit.plugin.handlers.common.CqHtmlTagHandler;
import com.exadel.aem.toolkit.plugin.handlers.common.MaxChildrenHandler;
import com.exadel.aem.toolkit.plugin.handlers.common.PropertyMappingHandler;
import com.exadel.aem.toolkit.plugin.handlers.dependson.DependsOnHandler;
import com.exadel.aem.toolkit.plugin.handlers.editconfig.DropTargetsHandler;
import com.exadel.aem.toolkit.plugin.handlers.editconfig.FormParametersHandler;
import com.exadel.aem.toolkit.plugin.handlers.editconfig.InplaceEditingHandler;
import com.exadel.aem.toolkit.plugin.handlers.editconfig.ListenersHandler;
import com.exadel.aem.toolkit.plugin.handlers.widgets.common.DataAnnotationHandler;
import com.exadel.aem.toolkit.plugin.handlers.widgets.common.DialogFieldAnnotationHandler;
import com.exadel.aem.toolkit.plugin.handlers.widgets.common.InheritanceHandler;
import com.exadel.aem.toolkit.plugin.handlers.widgets.common.MultipleAnnotationHandler;
import com.exadel.aem.toolkit.plugin.handlers.widgets.common.PropertyAnnotationHandler;
import com.exadel.aem.toolkit.plugin.handlers.widgets.common.ResourceTypeHandler;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class Handlers {
    public static final BiConsumer<Source, Target> DATA_ANNOTATIONS_HANDLER = new DataAnnotationHandler();
    private static final BiConsumer<Source, Target> CASUAL_ANNOTATIONS_HANDLER = new CasualAnnotationsHandler();
    private static final BiConsumer<Source, Target> PROPERTY_MAPPING_HANDLER = new PropertyMappingHandler();
    private static final BiConsumer<Source, Target> ALLOWED_CHILDREN_HANDLER = new AllowedChildrenHandler();
    private static final BiConsumer<Source, Target> MAX_CHILDREN_HANDLER = new MaxChildrenHandler();
    private static final BiConsumer<Source, Target> CHILD_EDIT_CONFIG_HANDLER = new CqChildEditConfigHandler().andThen(ALLOWED_CHILDREN_HANDLER).andThen(MAX_CHILDREN_HANDLER);
    private static final BiConsumer<Source, Target> COMPONENT_HANDLER = new ComponentHandler();
    private static final BiConsumer<Source, Target> DIALOG_HANDLER = new CqDialogHandler();
    private static final BiConsumer<Source, Target> EDIT_CONFIG_HANDLER = new CqEditConfigHandler().andThen(ALLOWED_CHILDREN_HANDLER).andThen(MAX_CHILDREN_HANDLER);
    private static final BiConsumer<Source, Target> HTML_TAG_HANDLER = new CqHtmlTagHandler();
    private static final Map<String, BiConsumer<Source, Target>> UI_HANDLERS = ImmutableMap.builder().put((Object)".content.xml", COMPONENT_HANDLER).put((Object)"_cq_dialog.xml", DIALOG_HANDLER).put((Object)"_cq_design_dialog.xml", DIALOG_HANDLER).put((Object)"_cq_editConfig.xml", EDIT_CONFIG_HANDLER).put((Object)"_cq_childEditConfig.xml", CHILD_EDIT_CONFIG_HANDLER).put((Object)"_cq_htmlTag.xml", HTML_TAG_HANDLER).build();
    private static final BiConsumer<Source, Target> DEPENDS_ON_HANDLER = new DependsOnHandler();
    private static final BiConsumer<Source, Target> DIALOG_FIELD_HANDLER = new DialogFieldAnnotationHandler();
    private static final BiConsumer<Source, Target> MULTIPLE_HANDLER = new MultipleAnnotationHandler();
    private static final BiConsumer<Source, Target> PROPERTY_ANNOTATION_HANDLER = new PropertyAnnotationHandler();
    private static final BiConsumer<Source, Target> RESOURCE_TYPE_HANDLER = new ResourceTypeHandler();
    private static final BiConsumer<Source, Target> MEMBER_HANDLER_CHAIN = RESOURCE_TYPE_HANDLER.andThen(PROPERTY_MAPPING_HANDLER).andThen(DATA_ANNOTATIONS_HANDLER).andThen(DIALOG_FIELD_HANDLER).andThen(CASUAL_ANNOTATIONS_HANDLER).andThen(DEPENDS_ON_HANDLER).andThen(PROPERTY_ANNOTATION_HANDLER).andThen(MULTIPLE_HANDLER);
    private static final BiConsumer<Source, Target> MEMBER_INHERITANCE_HANDLER_CHAIN = new InheritanceHandler(MEMBER_HANDLER_CHAIN).andThen(MEMBER_HANDLER_CHAIN);
    private static final BiConsumer<Source, Target> EDIT_CONFIG_DROP_TARGETS_HANDLER = new DropTargetsHandler();
    private static final BiConsumer<Source, Target> EDIT_CONFIG_FORM_PARAMS_HANDLER = new FormParametersHandler();
    private static final BiConsumer<Source, Target> EDIT_CONFIG_INPLACE_HANDLER = new InplaceEditingHandler();
    private static final BiConsumer<Source, Target> EDIT_CONFIG_LISTENERS_HANDLER = new ListenersHandler();
    private static final BiConsumer<Source, Target> EDIT_CONFIG_HANDLER_CHAIN = EDIT_CONFIG_DROP_TARGETS_HANDLER.andThen(EDIT_CONFIG_FORM_PARAMS_HANDLER).andThen(EDIT_CONFIG_INPLACE_HANDLER).andThen(EDIT_CONFIG_LISTENERS_HANDLER);
    private static final BiConsumer<Source, Target> NOOP_HANDLER = (source, target) -> {};

    private Handlers() {
    }

    public static BiConsumer<Source, Target> forScope(String scope) {
        BiConsumer<Source, Target> uiHandler = UI_HANDLERS.getOrDefault(scope, NOOP_HANDLER);
        return PROPERTY_MAPPING_HANDLER.andThen(DATA_ANNOTATIONS_HANDLER).andThen(uiHandler).andThen(CASUAL_ANNOTATIONS_HANDLER);
    }

    public static BiConsumer<Source, Target> forMember() {
        return MEMBER_INHERITANCE_HANDLER_CHAIN;
    }

    public static BiConsumer<Source, Target> forEditConfig() {
        return EDIT_CONFIG_HANDLER_CHAIN;
    }
}

