/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.common;

import com.exadel.aem.toolkit.api.annotations.policies.AllowedChildren;
import com.exadel.aem.toolkit.api.annotations.policies.PolicyMergeMode;
import com.exadel.aem.toolkit.api.annotations.policies.PolicyTarget;
import com.exadel.aem.toolkit.api.handlers.Handler;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import com.exadel.aem.toolkit.plugin.sources.ComponentSource;
import com.exadel.aem.toolkit.plugin.utils.ArrayUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class AllowedChildrenHandler
implements Handler {
    private static final String VALUE_POLICY_RESOLVER_FORMAT = "Granite.PolicyResolver.build('%s')";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new SimpleModule().addSerializer(AllowedChildren.class, (JsonSerializer)new AllowedChildrenSerializer()));

    public void accept(Source source, Target target) {
        ComponentSource componentSource = (ComponentSource)source.adaptTo(ComponentSource.class);
        if (componentSource != null) {
            AllowedChildren[] rules2 = (AllowedChildren[])componentSource.getViews().stream().map(viewSource -> (AllowedChildren[])viewSource.adaptTo(AllowedChildren[].class)).filter(ArrayUtils::isNotEmpty).flatMap(Arrays::stream).toArray(AllowedChildren[]::new);
            AllowedChildrenHandler.populatePolicies(rules2, target);
        } else {
            source.tryAdaptTo(AllowedChildren[].class).ifPresent(rules -> AllowedChildrenHandler.populatePolicies(rules, target));
        }
    }

    private static void populatePolicies(AllowedChildren[] rules, Target target) {
        List<AllowedChildren> allowedChildrenList = Arrays.stream(rules).filter(rule -> AllowedChildrenHandler.isEditConfig(target) == (PolicyTarget.CURRENT == rule.targetContainer())).map(AllowedChildrenHandler::combineValues).collect(() -> new RuleAccumulator(), RuleAccumulator::add, RuleAccumulator::addAll).getList();
        if (allowedChildrenList.isEmpty()) {
            return;
        }
        String json = AllowedChildrenHandler.toJson(allowedChildrenList, AllowedChildrenHandler.isEditConfig(target)).replace("'", "\\\\'");
        target.attribute("jcr:primaryType", "cq:EditConfig").getOrCreateTarget("cq:listeners").attribute("jcr:primaryType", "cq:EditListenersConfig").attribute("updatecomponentlist", String.format(VALUE_POLICY_RESOLVER_FORMAT, json));
    }

    private static boolean isEditConfig(Target target) {
        return "_cq_editConfig.xml".equals(target.getScope());
    }

    private static AllowedChildren combineValues(AllowedChildren rule) {
        if (ArrayUtils.isEmpty((Object[])rule.classes())) {
            return rule;
        }
        ArrayList<String> effectiveValues = new ArrayList<String>(Arrays.asList(rule.value()));
        Arrays.stream(rule.classes()).map(cls -> PluginRuntime.context().getReflection().getComponent((Class<?>)cls).getJcrPath()).filter(StringUtils::isNotBlank).forEach(effectiveValues::add);
        Map<String, A[]> modification = Collections.singletonMap("value", effectiveValues.stream().distinct().toArray(String[]::new));
        return (AllowedChildren)Metadata.from(rule, modification);
    }

    private static AllowedChildren combineValues(AllowedChildren left, AllowedChildren right) {
        if (ArrayUtils.isEmpty((Object[])right.value())) {
            return left;
        }
        if (ArrayUtils.isEmpty((Object[])left.value())) {
            return right;
        }
        String[] mergedValues = (String[])Stream.concat(Arrays.stream(left.value()), Arrays.stream(right.value())).distinct().toArray(String[]::new);
        Map<String, String[]> modification = Collections.singletonMap("value", mergedValues);
        return (AllowedChildren)Metadata.from(left, modification);
    }

    private static String toJson(List<AllowedChildren> rules, boolean isEditConfig) {
        ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
        objectNode.put("isEditConfig", isEditConfig);
        objectNode.set("rules", OBJECT_MAPPER.valueToTree(rules));
        return objectNode.toString();
    }

    private static class AllowedChildrenSerializer
    extends JsonSerializer<AllowedChildren> {
        private AllowedChildrenSerializer() {
        }

        public void serialize(AllowedChildren allowedChildren, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            this.serializeNonEmptyArray("value", ArrayUtil.flatten(allowedChildren.value()), jsonGenerator, serializerProvider);
            this.serializeNonEmptyArray("pageResourceTypes", ArrayUtil.flatten(allowedChildren.pageResourceTypes()), jsonGenerator, serializerProvider);
            this.serializeNonEmptyArray("templates", ArrayUtil.flatten(allowedChildren.templates()), jsonGenerator, serializerProvider);
            this.serializeNonEmptyArray("parentsResourceTypes", allowedChildren.parents(), jsonGenerator, serializerProvider);
            this.serializeNonEmptyArray("pagePaths", ArrayUtil.flatten(allowedChildren.pagePaths()), jsonGenerator, serializerProvider);
            this.serializeNonEmptyArray("containers", ArrayUtil.flatten(allowedChildren.resourceNames()), jsonGenerator, serializerProvider);
            if (PolicyMergeMode.OVERRIDE != allowedChildren.mode()) {
                serializerProvider.defaultSerializeField("mode", (Object)allowedChildren.mode(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }

        private void serializeNonEmptyArray(String fieldName, String[] value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (value.length == 0) {
                return;
            }
            serializerProvider.defaultSerializeField(fieldName, (Object)value, jsonGenerator);
        }
    }

    private static class RuleAccumulator {
        private final List<AllowedChildren> rules = new ArrayList<AllowedChildren>();

        private RuleAccumulator() {
        }

        void add(AllowedChildren rule) {
            if (rule == null) {
                return;
            }
            if (this.rules.isEmpty()) {
                this.rules.add(rule);
                return;
            }
            AllowedChildren existingMatch = this.rules.stream().filter(r -> RuleAccumulator.isMatch(r, rule)).findFirst().orElse(null);
            if (existingMatch != null) {
                this.rules.set(this.rules.indexOf(existingMatch), AllowedChildrenHandler.combineValues(existingMatch, rule));
            } else {
                this.rules.add(rule);
            }
        }

        void addAll(RuleAccumulator other) {
            if (other == null || other.getList() == null) {
                return;
            }
            other.getList().forEach(this::add);
        }

        List<AllowedChildren> getList() {
            return this.rules;
        }

        private static boolean isMatch(AllowedChildren left, AllowedChildren right) {
            if (left == null || right == null) {
                return false;
            }
            return left.mode() == right.mode() && left.targetContainer() == right.targetContainer() && ArrayUtil.equals(left.pagePaths(), right.pagePaths()) && ArrayUtil.equals(left.pageResourceTypes(), right.pageResourceTypes()) && ArrayUtil.equals(left.parents(), right.parents()) && ArrayUtil.equals(left.resourceNames(), right.resourceNames()) && ArrayUtil.equals(left.templates(), right.templates());
        }
    }
}

