/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.common;

import com.exadel.aem.toolkit.api.annotations.meta.DialogWidgetAnnotation;
import com.exadel.aem.toolkit.api.handlers.DialogWidgetHandler;
import com.exadel.aem.toolkit.api.handlers.Handler;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.adapters.DomAdapter;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.targets.LegacyHandlerAcceptor;
import com.exadel.aem.toolkit.plugin.utils.ordering.OrderingUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.util.CollectionUtils;
import org.w3c.dom.Element;

public class CasualAnnotationsHandler
implements BiConsumer<Source, Target> {
    private List<Handler> predefinedHandlers;

    public CasualAnnotationsHandler() {
    }

    public CasualAnnotationsHandler(List<Handler> handlers) {
        this.predefinedHandlers = handlers;
    }

    @Override
    public void accept(Source source, Target target) {
        List<Handler> handlers = this.getEffectiveHandlers(source, target.getScope());
        List<Handler> legacyHandlers = handlers.stream().filter(CasualAnnotationsHandler::isLegacyHandler).collect(Collectors.toList());
        Collection modernHandlers = CollectionUtils.subtract(handlers, legacyHandlers);
        OrderingUtil.sortHandlers(new ArrayList(modernHandlers)).forEach(handler -> handler.accept((Object)source, (Object)target));
        if (!legacyHandlers.isEmpty()) {
            Field field = (Field)source.adaptTo(Field.class);
            Element element = ((DomAdapter)target.adaptTo(DomAdapter.class)).composeElement(PluginRuntime.context().getXmlUtility().getDocument());
            if (element != null) {
                legacyHandlers.forEach(handler -> ((DialogWidgetHandler)handler).accept(element, field));
                ((LegacyHandlerAcceptor)target.adaptTo(LegacyHandlerAcceptor.class)).attributes(element);
            }
        }
    }

    private List<Handler> getEffectiveHandlers(Source source, String scope) {
        if (this.predefinedHandlers != null) {
            return this.predefinedHandlers;
        }
        List<Handler> result = PluginRuntime.context().getReflection().getHandlers(scope, (Annotation[])source.adaptTo(Annotation[].class));
        List sourceToNameMappingHandlers = Arrays.stream((Object[])source.adaptTo(Annotation[].class)).map(Annotation::annotationType).filter(a -> a.isAnnotationPresent(DialogWidgetAnnotation.class)).map(a -> a.getAnnotation(DialogWidgetAnnotation.class).source()).flatMap(CasualAnnotationsHandler::getMatchedHandlersByName).collect(Collectors.toList());
        result.addAll(sourceToNameMappingHandlers);
        return result;
    }

    private static Stream<DialogWidgetHandler> getMatchedHandlersByName(String source) {
        if (StringUtils.isEmpty((CharSequence)source)) {
            return Stream.empty();
        }
        return PluginRuntime.context().getReflection().getHandlers().stream().filter(DialogWidgetHandler.class::isInstance).filter(handler -> StringUtils.equals((CharSequence)source, (CharSequence)((DialogWidgetHandler)handler).getName())).map(DialogWidgetHandler.class::cast);
    }

    private static boolean isLegacyHandler(Handler handler) {
        try {
            Method legacyAcceptMethod = handler.getClass().getMethod("accept", Element.class, Field.class);
            return !legacyAcceptMethod.isDefault();
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }
}

