/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.common;

import com.exadel.aem.toolkit.api.annotations.container.Tab;
import com.exadel.aem.toolkit.api.annotations.layouts.Accordion;
import com.exadel.aem.toolkit.api.annotations.layouts.AccordionPanel;
import com.exadel.aem.toolkit.api.annotations.layouts.FixedColumns;
import com.exadel.aem.toolkit.api.annotations.layouts.Tabs;
import com.exadel.aem.toolkit.api.annotations.main.AemComponent;
import com.exadel.aem.toolkit.api.annotations.main.DesignDialog;
import com.exadel.aem.toolkit.api.annotations.main.Dialog;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.exceptions.ValidationException;
import com.exadel.aem.toolkit.plugin.handlers.placement.layouts.LayoutHandlers;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.metadata.RenderingFilter;
import com.exadel.aem.toolkit.plugin.targets.Targets;
import com.exadel.aem.toolkit.plugin.utils.ClassUtil;
import com.exadel.aem.toolkit.plugin.utils.ScopeUtil;
import com.exadel.aem.toolkit.plugin.writers.DialogLayout;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CqDialogHandler
implements BiConsumer<Source, Target> {
    private static final String OPENING_FORCE_IGNORE_FRESHNESS_TAG = "forceIgnoreFreshnessOpen";
    private static final String CLOSING_FORCE_IGNORE_FRESHNESS_TAG = "forceIgnoreFreshnessClose";
    private static final String ITEMS_ROOT_PATH = "content/items";
    private static final String TITLE_MISSING_EXCEPTION_MESSAGE = "Title property is missing for dialog in class ";

    @Override
    public void accept(Source source, Target target) {
        Annotation dialogAnnotation = "_cq_dialog.xml".equals(target.getScope()) ? (Annotation)source.adaptTo(Dialog.class) : (Annotation)source.adaptTo(DesignDialog.class);
        target.attributes(dialogAnnotation, new RenderingFilter(dialogAnnotation).and(member -> ScopeUtil.fits(target.getScope(), member))).attribute("sling:resourceType", "cq/gui/components/authoring/dialog");
        CqDialogHandler.populateTitleProperty(source, target);
        DialogLayout dialogLayout = CqDialogHandler.getLayout(source, target.getScope());
        LayoutHandlers.forLayout(dialogLayout).accept(source, target);
        CqDialogHandler.renderIgnoreFreshness(source, target);
    }

    private static void populateTitleProperty(Source source, Target target) {
        String currentTitleValue = null;
        if (source.adaptTo(Dialog.class) != null) {
            currentTitleValue = ((Dialog)source.adaptTo(Dialog.class)).title();
        }
        if (StringUtils.isEmpty(currentTitleValue) && source.adaptTo(DesignDialog.class) != null) {
            currentTitleValue = ((DesignDialog)source.adaptTo(DesignDialog.class)).title();
        }
        if (StringUtils.isEmpty(currentTitleValue) && source.adaptTo(AemComponent.class) == null) {
            ValidationException ex = new ValidationException(TITLE_MISSING_EXCEPTION_MESSAGE + source.getName(), new Object[0]);
            PluginRuntime.context().getExceptionHandler().handle((Exception)ex);
        } else if (StringUtils.isEmpty((CharSequence)currentTitleValue)) {
            target.attribute("jcr:title", ((AemComponent)source.adaptTo(AemComponent.class)).title());
        }
    }

    private static DialogLayout getLayout(Source source, String scope) {
        DialogLayout result = DialogLayout.DEFAULT_COLUMN;
        List<Class<?>> classHierarchy = ClassUtil.getInheritanceTree((Class)source.adaptTo(Class.class), true);
        ListIterator<Class<?>> classHierarchyIterator = classHierarchy.listIterator(classHierarchy.size());
        while (classHierarchyIterator.hasPrevious()) {
            Class<?> currentClass = classHierarchyIterator.previous();
            if (scope.equals("_cq_dialog.xml") && currentClass.isAnnotationPresent(Dialog.class) && currentClass.getDeclaredAnnotation(Dialog.class).tabs().length > 0) {
                return DialogLayout.TABS;
            }
            Tabs tabsAnnotation = currentClass.getDeclaredAnnotation(Tabs.class);
            if (tabsAnnotation != null && tabsAnnotation.value().length > 0) {
                return DialogLayout.TABS;
            }
            Accordion accordionAnnotation = currentClass.getDeclaredAnnotation(Accordion.class);
            if (accordionAnnotation != null && accordionAnnotation.value().length > 0) {
                return DialogLayout.ACCORDION;
            }
            FixedColumns fixedColumnsAnnotation = currentClass.getDeclaredAnnotation(FixedColumns.class);
            if (fixedColumnsAnnotation != null && fixedColumnsAnnotation.value().length > 0) {
                return DialogLayout.COLUMNS;
            }
            result = CqDialogHandler.getLayoutFromNestedClasses((Class)source.adaptTo(Class.class));
            if (result.equals((Object)DialogLayout.DEFAULT_COLUMN)) continue;
            return result;
        }
        return result;
    }

    private static DialogLayout getLayoutFromNestedClasses(Class<?> componentClass) {
        if (ArrayUtils.isEmpty((Object[])componentClass.getDeclaredClasses())) {
            return DialogLayout.DEFAULT_COLUMN;
        }
        for (Class<?> nested : componentClass.getDeclaredClasses()) {
            if (nested.isAnnotationPresent(com.exadel.aem.toolkit.api.annotations.layouts.Tab.class) || nested.isAnnotationPresent(Tab.class)) {
                return DialogLayout.TABS;
            }
            if (!nested.isAnnotationPresent(AccordionPanel.class)) continue;
            return DialogLayout.ACCORDION;
        }
        return DialogLayout.DEFAULT_COLUMN;
    }

    private static void renderIgnoreFreshness(Source source, Target target) {
        boolean forceIgnoreFreshness;
        boolean bl = forceIgnoreFreshness = source.adaptTo(Dialog.class) != null ? ((Dialog)source.adaptTo(Dialog.class)).forceIgnoreFreshness() : ((DesignDialog)source.adaptTo(DesignDialog.class)).forceIgnoreFreshness();
        if (!forceIgnoreFreshness) {
            return;
        }
        Target itemsRoot = target.getTarget(ITEMS_ROOT_PATH);
        if (itemsRoot == null || itemsRoot.getChildren().isEmpty()) {
            return;
        }
        Target forceIgnoreFreshnessOpen = Targets.newTarget(OPENING_FORCE_IGNORE_FRESHNESS_TAG).attribute("sling:resourceType", "etoolbox-authoring-kit/components/authoring/ignoreFreshnessToggler");
        Target forceIgnoreFreshnessClose = Targets.newTarget(CLOSING_FORCE_IGNORE_FRESHNESS_TAG).attribute("sling:resourceType", "etoolbox-authoring-kit/components/authoring/ignoreFreshnessToggler");
        itemsRoot.addTarget(forceIgnoreFreshnessOpen, 0);
        itemsRoot.addTarget(forceIgnoreFreshnessClose, itemsRoot.getChildren().size());
    }
}

