/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.common;

import com.exadel.aem.toolkit.api.annotations.main.CommonProperty;
import com.exadel.aem.toolkit.api.annotations.meta.DialogAnnotation;
import com.exadel.aem.toolkit.api.handlers.DialogHandler;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomHandler {
    public void accept(Source source, Document document, String scope) {
        this.writeCommonProperties((Class)source.adaptTo(Class.class), document, scope);
        if ("_cq_dialog.xml".equals(scope)) {
            DomHandler.applyLegacyDialogHandlers((Class)source.adaptTo(Class.class), document.getDocumentElement());
        }
    }

    private void writeCommonProperties(Class<?> componentClass, Document document, String scope) {
        Arrays.stream(componentClass.getAnnotationsByType(CommonProperty.class)).filter(p -> StringUtils.equals((CharSequence)scope, (CharSequence)p.scope())).forEach(p -> DomHandler.writeCommonProperty(p, DomHandler.getElementNodes(p.path(), document)));
    }

    private static void writeCommonProperty(CommonProperty property, List<Element> elements) {
        elements.forEach(target -> target.setAttribute(property.name(), property.value()));
    }

    private static List<Element> getElementNodes(String xPath, Document document) {
        XPath xPathInstance = XPathFactory.newInstance().newXPath();
        ArrayList<Element> result = new ArrayList<Element>();
        try {
            NodeList nodes = (NodeList)xPathInstance.evaluate(xPath, document, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node instanceof Document) {
                    result.add(((Document)node).getDocumentElement());
                    continue;
                }
                if (!(node instanceof Element)) continue;
                result.add((Element)node);
            }
            if (result.isEmpty()) {
                throw new XPathExpressionException("Resolves to null or node of non-element type");
            }
        }
        catch (XPathExpressionException e) {
            PluginRuntime.context().getExceptionHandler().handle(String.format("Wrong XPath argument '%s'", xPath), (Exception)e);
        }
        return result;
    }

    private static void applyLegacyDialogHandlers(Class<?> componentClass, Element element) {
        List<DialogAnnotation> customAnnotations = DomHandler.getLegacyDialogAnnotations(componentClass);
        PluginRuntime.context().getReflection().getHandlers().stream().filter(handler -> handler instanceof DialogHandler).map(handler -> (DialogHandler)handler).filter(handler -> customAnnotations.stream().anyMatch(annotation -> StringUtils.equals((CharSequence)annotation.source(), (CharSequence)handler.getName()))).forEach(handler -> handler.accept(element, componentClass));
    }

    private static List<DialogAnnotation> getLegacyDialogAnnotations(Class<?> componentClass) {
        return Arrays.stream(componentClass.getDeclaredAnnotations()).map(annotation -> Metadata.from(annotation).getAnnotation(DialogAnnotation.class)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

