/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.common;

import com.exadel.aem.toolkit.api.annotations.policies.MaxChildren;
import com.exadel.aem.toolkit.api.annotations.policies.PolicyTarget;
import com.exadel.aem.toolkit.api.handlers.Handler;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;

public class MaxChildrenHandler
implements Handler {
    public static final String MAX_CHILDREN_RESOLVER_NAME = "resolvemaxchildren";
    private static final String MAX_CHILDREN_RESOLVER_FORMAT = "() => %d";

    public void accept(Source source, Target target) {
        source.tryAdaptTo(MaxChildren.class).ifPresent(adaptation -> MaxChildrenHandler.populate(adaptation, target));
    }

    private static void populate(MaxChildren rule, Target target) {
        if (MaxChildrenHandler.isEditConfig(target) == (PolicyTarget.CURRENT == rule.targetContainer())) {
            target.attribute("jcr:primaryType", "cq:EditConfig").getOrCreateTarget("cq:listeners").attribute("jcr:primaryType", "cq:EditListenersConfig").attribute(MAX_CHILDREN_RESOLVER_NAME, String.format(MAX_CHILDREN_RESOLVER_FORMAT, rule.value()));
        }
    }

    private static boolean isEditConfig(Target target) {
        return "_cq_editConfig.xml".equals(target.getScope());
    }
}

