/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.common;

import com.exadel.aem.toolkit.api.annotations.main.AemComponent;
import com.exadel.aem.toolkit.api.annotations.main.Dialog;
import com.exadel.aem.toolkit.api.annotations.meta.AnnotationRendering;
import com.exadel.aem.toolkit.api.annotations.meta.PropertyMapping;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import com.exadel.aem.toolkit.plugin.metadata.RenderingFilter;
import com.exadel.aem.toolkit.plugin.utils.ScopeUtil;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public class PropertyMappingHandler
implements BiConsumer<Source, Target> {
    private static final List<Class<? extends Annotation>> SPECIALLY_PROCESSED = Arrays.asList(AemComponent.class, Dialog.class);

    @Override
    public void accept(Source source, Target target) {
        Annotation[] annotations = (Annotation[])source.adaptTo(Annotation[].class);
        Arrays.stream(annotations).map(Metadata::from).filter(metadata -> metadata.getAnyAnnotation(AnnotationRendering.class, PropertyMapping.class) != null).filter(metadata -> !SPECIALLY_PROCESSED.contains(metadata.annotationType())).filter(metadata -> {
            AnnotationRendering annotationRendering = metadata.getAnnotation(AnnotationRendering.class);
            return annotationRendering == null || ScopeUtil.fits(target.getScope(), metadata, annotations);
        }).forEach(annotation -> target.attributes((Annotation)annotation, (Predicate)new RenderingFilter((Annotation)annotation)));
    }
}

