/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.dependson;

import com.exadel.aem.toolkit.api.annotations.assets.dependson.DependsOn;
import com.exadel.aem.toolkit.api.annotations.assets.dependson.DependsOnConfig;
import com.exadel.aem.toolkit.api.annotations.assets.dependson.DependsOnParam;
import com.exadel.aem.toolkit.api.annotations.assets.dependson.DependsOnRef;
import com.exadel.aem.toolkit.api.annotations.assets.dependson.DependsOnRefTypes;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.exceptions.ValidationException;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.utils.StringUtil;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DependsOnHandler
implements BiConsumer<Source, Target> {
    static final String EMPTY_VALUES_EXCEPTION_MESSAGE = "Non-empty string values are required for DependsOn params";

    @Override
    public void accept(Source source, Target target) {
        if (source.adaptTo(DependsOn.class) != null) {
            DependsOnHandler.handleDependsOn((DependsOn)source.adaptTo(DependsOn.class), target);
        } else if (source.adaptTo(DependsOnConfig.class) != null) {
            DependsOnHandler.handleDependsOnConfig((DependsOnConfig)source.adaptTo(DependsOnConfig.class), target);
        }
        DependsOnHandler.handleDependsOnRefValue(source, target);
    }

    private static void handleDependsOn(DependsOn value, Target target) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{value.query(), value.action()})) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ValidationException(EMPTY_VALUES_EXCEPTION_MESSAGE, new Object[0]));
            return;
        }
        HashMap valueMap = Maps.newHashMap();
        String escapedQuery = DependsOnHandler.escapeValue(value.query());
        valueMap.put("dependsOn", escapedQuery);
        valueMap.put("dependsOnAction", value.action());
        valueMap.putAll(DependsOnHandler.buildParamsMap(value, 0));
        target.getOrCreateTarget("granite:data").attributes((Map)valueMap);
    }

    private static void handleDependsOnConfig(DependsOnConfig value, Target target) {
        List validDeclarations = Arrays.stream(value.value()).filter(dependsOn -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dependsOn.action(), dependsOn.query()})).collect(Collectors.toList());
        if (value.value().length != validDeclarations.size()) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ValidationException(EMPTY_VALUES_EXCEPTION_MESSAGE, new Object[0]));
        }
        HashMap<String, String> valueMap = new HashMap<String, String>();
        String queries = validDeclarations.stream().map(DependsOn::query).map(str -> StringUtils.replace((String)str, (String)";", (String)"\\\\;")).collect(Collectors.joining(";"));
        String actions = validDeclarations.stream().map(DependsOn::action).collect(Collectors.joining(";"));
        valueMap.put("dependsOn", queries);
        valueMap.put("dependsOnAction", actions);
        HashMap counter = new HashMap();
        validDeclarations.stream().map(dependsOn -> DependsOnHandler.buildParamsMap(dependsOn, counter.merge(dependsOn.action(), 1, Integer::sum) - 1)).forEach(valueMap::putAll);
        target.getOrCreateTarget("granite:data").attributes(valueMap);
    }

    private static Map<String, String> buildParamsMap(DependsOn dependsOn, int index) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        for (DependsOnParam param : dependsOn.params()) {
            String paramName = StringUtils.joinWith((String)"-", (Object[])new Object[]{"dependsOn", dependsOn.action(), param.name()});
            if (index > 0) {
                paramName = StringUtils.joinWith((String)"-", (Object[])new Object[]{paramName, index});
            }
            valueMap.put(paramName, param.value());
        }
        return valueMap;
    }

    private static void handleDependsOnRefValue(Source source, Target target) {
        DependsOnRef value = (DependsOnRef)source.adaptTo(DependsOnRef.class);
        if (value == null) {
            return;
        }
        String dependsOnRefName = value.name();
        if (StringUtils.isBlank((CharSequence)dependsOnRefName)) {
            dependsOnRefName = source.getName();
        }
        HashMap valueMap = Maps.newHashMap();
        valueMap.put("dependsOnRef", dependsOnRefName);
        if (!value.type().toString().equals(DependsOnRefTypes.AUTO.toString())) {
            valueMap.put("dependsOnRefType", value.type().toString().toLowerCase());
        }
        if (value.lazy()) {
            valueMap.put("dependsOnRefLazy", "");
        }
        target.getOrCreateTarget("granite:data").attributes((Map)valueMap);
    }

    private static String escapeValue(String value) {
        String result = StringUtils.replace((String)value, (String)";", (String)"\\\\;");
        result = StringUtil.escapeArray(result);
        return result;
    }
}

