/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.dependson;

import com.exadel.aem.toolkit.api.annotations.assets.dependson.DependsOnTab;
import com.exadel.aem.toolkit.api.annotations.assets.dependson.DependsOnTabConfig;
import com.exadel.aem.toolkit.api.handlers.Handler;
import com.exadel.aem.toolkit.api.handlers.Handles;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.exceptions.InvalidContainerException;
import com.exadel.aem.toolkit.plugin.exceptions.ValidationException;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.utils.NamingUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@Handles(value={DependsOnTab.class, DependsOnTabConfig.class}, scope={"_cq_dialog.xml", "_cq_design_dialog.xml"})
public class DependsOnTabHandler
implements Handler {
    private static final String TAB_ITEMS_NODE_PATH = String.join((CharSequence)"/", "content", "items", "tabs", "items");

    public void accept(Source source, Target target) {
        source.tryAdaptTo(DependsOnTab.class).ifPresent(dependsOnTab -> this.handleDependsOnTab((DependsOnTab)dependsOnTab, target));
        source.tryAdaptTo(DependsOnTabConfig.class).ifPresent(dependsOnTabConfig -> this.handleDependsOnTabConfig((DependsOnTabConfig)dependsOnTabConfig, target));
    }

    private void handleDependsOnTab(DependsOnTab value, Target target) {
        if (!target.exists(TAB_ITEMS_NODE_PATH)) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new InvalidContainerException());
            return;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{value.tabTitle(), value.query()})) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ValidationException("Non-empty string values are required for DependsOn params", new Object[0]));
            return;
        }
        if (target.exists(TAB_ITEMS_NODE_PATH + "/" + NamingUtil.getValidNodeName(value.tabTitle()))) {
            ImmutableMap dependsOnAttributes = ImmutableMap.of((Object)"dependsOn", (Object)value.query(), (Object)"dependsOnAction", (Object)"tab-visibility");
            target.getTarget(TAB_ITEMS_NODE_PATH + "/" + value.tabTitle()).getOrCreateTarget("granite:data").attributes((Map)dependsOnAttributes);
        } else {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new InvalidContainerException(value.tabTitle()));
        }
    }

    private void handleDependsOnTabConfig(DependsOnTabConfig value, Target target) {
        Arrays.stream(value.value()).forEach(val -> this.handleDependsOnTab((DependsOnTab)val, target));
    }
}

