/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.editconfig;

import com.exadel.aem.toolkit.api.annotations.editconfig.DropTargetConfig;
import com.exadel.aem.toolkit.api.annotations.editconfig.EditConfig;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.exceptions.ValidationException;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.metadata.RenderingFilter;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DropTargetsHandler
implements BiConsumer<Source, Target> {
    private static final String INVALID_NAME_MESSAGE = "Invalid drop target node name";

    @Override
    public void accept(Source source, Target target) {
        EditConfig editConfig = (EditConfig)source.adaptTo(EditConfig.class);
        if (editConfig.dropTargets().length == 0) {
            return;
        }
        Target dropTargetsElement = target.getOrCreateTarget("cq:dropTargets");
        for (int i = 0; i < editConfig.dropTargets().length; ++i) {
            DropTargetConfig dropTargetConfig = editConfig.dropTargets()[i];
            if (StringUtils.isBlank((CharSequence)dropTargetConfig.nodeName())) {
                PluginRuntime.context().getExceptionHandler().handle((Exception)new ValidationException(INVALID_NAME_MESSAGE, new Object[0]));
            }
            dropTargetsElement.getOrCreateTarget(dropTargetConfig.nodeName()).attribute("jcr:primaryType", "cq:DropTargetConfig").attributes((Annotation)dropTargetConfig, (Predicate)new RenderingFilter((Annotation)dropTargetConfig)).attribute("accept", Arrays.stream(dropTargetConfig.accept()).collect(Collectors.toList()).toString()).attribute("groups", Arrays.stream(dropTargetConfig.groups()).collect(Collectors.toList()).toString());
        }
    }
}

