/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.editconfig;

import com.exadel.aem.toolkit.api.annotations.editconfig.EditConfig;
import com.exadel.aem.toolkit.api.annotations.editconfig.InplaceEditingConfig;
import com.exadel.aem.toolkit.api.annotations.widgets.rte.RichTextEditor;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.api.markers._Default;
import com.exadel.aem.toolkit.plugin.exceptions.ReflectionException;
import com.exadel.aem.toolkit.plugin.handlers.widgets.common.InheritanceHandler;
import com.exadel.aem.toolkit.plugin.handlers.widgets.rte.RichTextEditorHandler;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.metadata.RenderingFilter;
import com.exadel.aem.toolkit.plugin.sources.Sources;
import com.exadel.aem.toolkit.plugin.utils.NamingUtil;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class InplaceEditingHandler
implements BiConsumer<Source, Target> {
    @Override
    public void accept(Source source, Target target) {
        EditConfig editConfig = (EditConfig)source.adaptTo(EditConfig.class);
        if (ArrayUtils.isEmpty((Object[])editConfig.inplaceEditing()) || editConfig.inplaceEditing().length == 1 && "empty".equals(editConfig.inplaceEditing()[0].type())) {
            return;
        }
        Target inplaceEditingNode = target.getOrCreateTarget("cq:inplaceEditing").attribute("sling:resourceType", "cq:InplaceEditingConfig").attribute("active", true);
        if (editConfig.inplaceEditing().length > 1) {
            inplaceEditingNode.attribute("editorType", "hybrid".toLowerCase());
            InplaceEditingHandler.getChildEditorsNode(editConfig, inplaceEditingNode);
            InplaceEditingHandler.getConfigNode(editConfig, inplaceEditingNode);
        } else {
            inplaceEditingNode.attribute("editorType", editConfig.inplaceEditing()[0].type().toLowerCase());
            Target configNode = inplaceEditingNode.getOrCreateTarget("config");
            InplaceEditingHandler.populateConfigNode(editConfig.inplaceEditing()[0], configNode);
        }
    }

    private static void getChildEditorsNode(EditConfig config, Target target) {
        Target childEditorsNode = target.getOrCreateTarget("cq:childEditors");
        Arrays.stream(config.inplaceEditing()).forEach(inplaceEditingConfig -> InplaceEditingHandler.getSingleChildEditorNode(inplaceEditingConfig, childEditorsNode));
    }

    private static void getSingleChildEditorNode(InplaceEditingConfig config, Target target) {
        target.getOrCreateTarget(InplaceEditingHandler.getConfigName(config)).attribute("jcr:primaryType", "cq:ChildEditorConfig").attribute("title", StringUtils.isNotBlank((CharSequence)config.title()) ? config.title() : InplaceEditingHandler.getConfigName(config)).attribute("type", config.type().toLowerCase());
    }

    private static void getConfigNode(EditConfig config, Target target) {
        Target configNode = target.getOrCreateTarget("config");
        for (InplaceEditingConfig childConfig : config.inplaceEditing()) {
            Target childConfigNode = configNode.getOrCreateTarget(InplaceEditingHandler.getConfigName(childConfig)).attribute("sling:resourceType", "cq:InplaceEditingConfig");
            InplaceEditingHandler.populateConfigNode(childConfig, childConfigNode);
        }
    }

    private static void populateConfigNode(InplaceEditingConfig config, Target target) {
        String propertyName = InplaceEditingHandler.getValidPropertyName(config.propertyName());
        String textPropertyName = config.textPropertyName().isEmpty() ? propertyName : InplaceEditingHandler.getValidPropertyName(config.textPropertyName());
        target.attribute("editElementQuery", config.editElementQuery()).attribute("propertyName", propertyName).attribute("textPropertyName", textPropertyName);
        InplaceEditingHandler.populateRteConfig(config, target);
    }

    private static String getValidPropertyName(String rawName) {
        String propertyName = NamingUtil.getValidFieldName(rawName);
        if (propertyName.startsWith("../")) {
            return propertyName;
        }
        return "./" + propertyName;
    }

    private static void populateRteConfig(InplaceEditingConfig config, Target target) {
        Source referencedRteField = InplaceEditingHandler.getReferencedRteField(config);
        if (referencedRteField != null && referencedRteField.adaptTo(RichTextEditor.class) != null) {
            RichTextEditorHandler rteHandler = new RichTextEditorHandler(false);
            new InheritanceHandler((BiConsumer<Source, Target>)((Object)rteHandler)).andThen(rteHandler).accept(referencedRteField, target);
            RichTextEditor rteAnnotation = (RichTextEditor)referencedRteField.adaptTo(RichTextEditor.class);
            target.attributes((Annotation)rteAnnotation, new RenderingFilter((Annotation)rteAnnotation).and(method -> !"useFixedInlineToolbar".equals(method.getName())));
        }
        new RichTextEditorHandler(false).accept(config.richTextConfig(), target);
    }

    private static Source getReferencedRteField(InplaceEditingConfig config) {
        if (config.richText().value().equals(_Default.class) && StringUtils.isBlank((CharSequence)config.richText().field())) {
            return null;
        }
        try {
            return Sources.fromMember(config.richText().value().getDeclaredField(config.richText().field()), config.richText().value());
        }
        catch (NoSuchFieldException e) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ReflectionException(config.richText().value(), config.richText().field()));
            return null;
        }
    }

    private static String getConfigName(InplaceEditingConfig config) {
        String result;
        String string = result = StringUtils.isNotBlank((CharSequence)config.name()) ? config.name() : config.propertyName();
        if (result.contains("/")) {
            return StringUtils.substringAfterLast((String)result, (String)"/").trim();
        }
        return result.trim();
    }
}

