/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.placement;

import com.exadel.aem.toolkit.api.handlers.MemberSource;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.adapters.ResourceTypeSetting;
import com.exadel.aem.toolkit.plugin.exceptions.InvalidLayoutException;
import com.exadel.aem.toolkit.plugin.handlers.placement.registries.SectionsRegistry;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.sources.ModifiableMemberSource;
import com.exadel.aem.toolkit.plugin.utils.NamingUtil;
import com.exadel.aem.toolkit.plugin.utils.ordering.OrderingUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;

class PlacementCollisionSolver {
    private static final String TYPE_FIELD = "Field";
    private static final String TYPE_METHOD = "Method";
    private static final String NAMING_COLLISION_MESSAGE_TEMPLATE = "%s named \"%s\" in class \"%s\" collides with the %s named \"%s\" in class \"%s\" (%s). This may cause unexpected behavior";
    private static final String REASON_AMBIGUOUS_ORDER = "attributes of the parent class member will have precedence";
    private static final String REASON_DIFFERENT_RESTYPE = "different resource types provided";
    private static final String CIRCULAR_PLACEMENT_MESSAGE_TEMPLATE = "%s named \"%s\" in class \"%s\" requests to be placed in container declared by %s named \"%s\" in class \"%s\" while the latter is already a child container of the first";

    private PlacementCollisionSolver() {
    }

    public static void checkForCollisions(List<Source> sources) {
        List distinctNames = sources.stream().map(NamingUtil::stripGetterPrefix).distinct().collect(Collectors.toList());
        if (distinctNames.size() == sources.size()) {
            return;
        }
        for (String name : distinctNames) {
            PlacementCollisionSolver.checkForNameCollisions(sources, name);
            PlacementCollisionSolver.checkForResourceTypeCollisions(sources, name);
        }
    }

    private static void checkForNameCollisions(List<Source> sources, String name) {
        LinkedList<Source> sameNameMembers = PlacementCollisionSolver.getMembersWithSameName(sources, name);
        LinkedList sameNameMembersByOrigin = sameNameMembers.stream().sorted(OrderingUtil::compareByOrigin).collect(Collectors.toCollection(LinkedList::new));
        if (!sameNameMembers.getLast().equals(sameNameMembersByOrigin.getLast())) {
            PlacementCollisionSolver.reportCollision((MemberSource)((Source)sameNameMembersByOrigin.getLast()).adaptTo(MemberSource.class), (MemberSource)sameNameMembers.getLast().adaptTo(MemberSource.class), REASON_AMBIGUOUS_ORDER);
        }
    }

    private static void checkForResourceTypeCollisions(List<Source> sources, String name) {
        LinkedList<Source> sameNameMembers = PlacementCollisionSolver.getMembersWithSameName(sources, name);
        Predicate<Source> fieldPredicate = PlacementCollisionSolver::isField;
        Predicate<Source> methodPredicate = PlacementCollisionSolver::isMethod;
        for (Predicate currentMemberType : Arrays.asList(fieldPredicate, methodPredicate)) {
            Map membersByResourceType = sameNameMembers.stream().filter(currentMemberType).collect(Collectors.toMap(source -> ((ResourceTypeSetting)source.adaptTo(ResourceTypeSetting.class)).getValue(), source -> source, (first, second) -> second, LinkedHashMap::new));
            if (membersByResourceType.size() <= 1) continue;
            Source[] competitorArray = membersByResourceType.values().toArray(new Source[0]);
            PlacementCollisionSolver.reportCollision((MemberSource)competitorArray[1].adaptTo(MemberSource.class), (MemberSource)competitorArray[0].adaptTo(MemberSource.class), REASON_DIFFERENT_RESTYPE);
        }
    }

    private static void reportCollision(MemberSource first, MemberSource second, String reason) {
        PluginRuntime.context().getExceptionHandler().handle((Exception)new InvalidLayoutException(String.format(NAMING_COLLISION_MESSAGE_TEMPLATE, PlacementCollisionSolver.isField((Source)first) ? TYPE_FIELD : TYPE_METHOD, first.getName(), first.getDeclaringClass().getSimpleName(), PlacementCollisionSolver.isField((Source)second) ? TYPE_FIELD.toLowerCase() : TYPE_METHOD.toLowerCase(), second.getName(), second.getDeclaringClass().getSimpleName(), reason)));
    }

    public static void resolveFieldMethodNameCoincidences(List<Source> sources) {
        List fields = sources.stream().filter(PlacementCollisionSolver::isField).collect(Collectors.toList());
        for (Source currentField : fields) {
            LinkedList<Source> methodsToRename = PlacementCollisionSolver.getMembersWithSameName(sources, currentField.getName(), member -> PlacementCollisionSolver.isMethod(member) && PlacementCollisionSolver.isSameOrSuperClass(currentField, member) && PlacementCollisionSolver.hasDifferentResourceType(currentField, member));
            if (methodsToRename.isEmpty()) continue;
            HashMap methodGroupsByResourceType = new HashMap();
            methodsToRename.forEach(method -> methodGroupsByResourceType.computeIfAbsent(((ResourceTypeSetting)method.adaptTo(ResourceTypeSetting.class)).getValue(), key -> new ArrayList()).add(method));
            for (Map.Entry methodGroupByResourceType : methodGroupsByResourceType.entrySet()) {
                List methodGroup = (List)methodGroupByResourceType.getValue();
                String simpleResourceType = StringUtils.substringAfterLast((String)((String)methodGroupByResourceType.getKey()), (String)"/");
                String newName = currentField.getName() + "_" + simpleResourceType.toLowerCase();
                methodGroup.forEach(method -> ((ModifiableMemberSource)method.adaptTo(ModifiableMemberSource.class)).setName(newName));
            }
        }
    }

    private static boolean isSameOrSuperClass(Source first, Source second) {
        Class firstClass = ((MemberSource)first.adaptTo(MemberSource.class)).getDeclaringClass();
        Class secondClass = ((MemberSource)second.adaptTo(MemberSource.class)).getDeclaringClass();
        return ClassUtils.isAssignable((Class)firstClass, (Class)secondClass);
    }

    private static boolean hasDifferentResourceType(Source first, Source second) {
        return !((ResourceTypeSetting)first.adaptTo(ResourceTypeSetting.class)).getValue().equals(((ResourceTypeSetting)second.adaptTo(ResourceTypeSetting.class)).getValue());
    }

    public static void checkForCircularPlacement(Source host, Target hostContainer, Source candidate, Target candidateContainer) {
        if (PlacementCollisionSolver.isProneToCircularPlacement(host, hostContainer, candidate, candidateContainer) && PlacementCollisionSolver.isProneToCircularPlacement(candidate, candidateContainer, host, hostContainer)) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new InvalidLayoutException(String.format(CIRCULAR_PLACEMENT_MESSAGE_TEMPLATE, PlacementCollisionSolver.isField(candidate) ? TYPE_FIELD : TYPE_METHOD, candidate.getName(), ((MemberSource)candidate).getDeclaringClass().getSimpleName(), PlacementCollisionSolver.isField(host) ? TYPE_FIELD.toLowerCase() : TYPE_METHOD.toLowerCase(), host.getName(), ((MemberSource)host).getDeclaringClass().getSimpleName())));
        }
    }

    private static boolean isProneToCircularPlacement(Source first, Target firstContainer, Source second, Target secondContainer) {
        if (!SectionsRegistry.isAvailableFor(first) || !SectionsRegistry.isAvailableFor(second)) {
            return false;
        }
        if (SectionsRegistry.from(second, secondContainer).getAvailable().stream().anyMatch(section -> section.canContain(first))) {
            return true;
        }
        return secondContainer.findChild(child -> child.equals(firstContainer)) != null;
    }

    private static LinkedList<Source> getMembersWithSameName(List<Source> sources, String name) {
        return PlacementCollisionSolver.getMembersWithSameName(sources, name, null);
    }

    private static LinkedList<Source> getMembersWithSameName(List<Source> sources, String name, Predicate<Source> filter) {
        return sources.stream().filter(source -> StringUtils.equals((CharSequence)NamingUtil.stripGetterPrefix(source), (CharSequence)name)).filter(source -> filter == null || filter.test((Source)source)).map(source -> (MemberSource)source.adaptTo(MemberSource.class)).collect(Collectors.toCollection(LinkedList::new));
    }

    private static boolean isField(Source source) {
        return source.adaptTo(Field.class) != null;
    }

    private static boolean isMethod(Source source) {
        return source.adaptTo(Method.class) != null;
    }
}

