/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.placement;

import com.exadel.aem.toolkit.api.annotations.layouts.Place;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.adapters.AdaptationBase;
import com.exadel.aem.toolkit.plugin.adapters.PlaceSetting;
import com.exadel.aem.toolkit.plugin.handlers.Handlers;
import com.exadel.aem.toolkit.plugin.handlers.placement.PlacementCollisionSolver;
import com.exadel.aem.toolkit.plugin.handlers.placement.registries.MembersRegistry;
import com.exadel.aem.toolkit.plugin.handlers.placement.registries.SectionsRegistry;
import com.exadel.aem.toolkit.plugin.handlers.placement.sections.Section;
import com.exadel.aem.toolkit.plugin.utils.NamingUtil;
import com.exadel.aem.toolkit.plugin.utils.ordering.OrderingUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class PlacementHelper {
    private Source source;
    private Target container;
    private SectionsRegistry sections;
    private MembersRegistry members;

    private PlacementHelper() {
    }

    public void doPlacement() {
        if (this.sections != null && !this.sections.getAvailable().isEmpty()) {
            this.doMultiSectionPlacement();
        } else {
            this.doSimplePlacement();
        }
    }

    private void doMultiSectionPlacement() {
        Iterator<Section> sectionIterator = this.sections.getAvailable().iterator();
        int iterationStep = 0;
        while (sectionIterator.hasNext()) {
            boolean isFirstSection = iterationStep++ == 0;
            Section currentSection = sectionIterator.next();
            List<Source> currentSectionMembers = new ArrayList<Source>(currentSection.getSources());
            List assignableSectionMembers = this.members.getAllAvailable().stream().filter(member -> currentSection.canContain((Source)member, isFirstSection)).collect(Collectors.toList());
            boolean needToSortAgain = !currentSectionMembers.isEmpty() && !assignableSectionMembers.isEmpty();
            currentSectionMembers.addAll(assignableSectionMembers);
            if (needToSortAgain) {
                currentSectionMembers = OrderingUtil.sortMembers(currentSectionMembers);
            }
            if (!currentSection.isIgnored()) {
                this.doSectionPlacement(currentSectionMembers, currentSection);
                continue;
            }
            currentSectionMembers.forEach(item -> this.members.checkOut((Source)item));
        }
    }

    private void doSectionPlacement(List<Source> candidates, Section section) {
        PlacementCollisionSolver.checkForCollisions(candidates);
        PlacementCollisionSolver.resolveFieldMethodNameCoincidences(candidates);
        Target itemsElement = section.createItemsContainer(this.container).getOrCreateTarget("items");
        for (Source candidate : candidates) {
            this.members.checkOut(candidate);
            if (((AdaptationBase)candidate).hasAdaptation(PlaceSetting.class) && ((PlaceSetting)candidate.adaptTo(PlaceSetting.class)).getMatchingTarget() != null) {
                Target existingElement = ((PlaceSetting)candidate.adaptTo(PlaceSetting.class)).getMatchingTarget();
                PlacementCollisionSolver.checkForCircularPlacement(this.source, this.container, candidate, existingElement);
                itemsElement.addTarget(existingElement);
                continue;
            }
            Target newElement = itemsElement.getOrCreateTarget(NamingUtil.stripGetterPrefix(candidate));
            PlacementCollisionSolver.checkForCircularPlacement(this.source, this.container, candidate, newElement);
            Handlers.forMember().accept(candidate, newElement);
        }
    }

    private void doSimplePlacement() {
        PlacementCollisionSolver.checkForCollisions(this.members.getAvailable());
        PlacementCollisionSolver.resolveFieldMethodNameCoincidences(this.members.getAvailable());
        Target itemsElement = this.container.getOrCreateTarget("items");
        while (!this.members.getAvailable().isEmpty()) {
            Source candidate = this.members.getAvailable().get(0);
            Target newElement = itemsElement.getOrCreateTarget(NamingUtil.stripGetterPrefix(candidate));
            if (!candidate.tryAdaptTo(Place.class).isPresent()) {
                this.members.checkOut(candidate);
            } else {
                PlaceSetting placeSetting = (PlaceSetting)candidate.adaptTo(PlaceSetting.class);
                if (!placeSetting.getValue().isEmpty()) {
                    this.members.softCheckOut(candidate);
                    placeSetting.setMatchingTarget(newElement);
                } else {
                    this.members.checkOut(candidate);
                }
            }
            Handlers.forMember().accept(candidate, newElement);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Source source;
        private Target container;
        private SectionsRegistry sections;
        private MembersRegistry members;

        private Builder() {
        }

        public Builder source(Source value) {
            this.source = value;
            return this;
        }

        public Builder container(Target value) {
            this.container = value;
            return this;
        }

        public Builder sections(SectionsRegistry value) {
            this.sections = value;
            return this;
        }

        public Builder members(MembersRegistry value) {
            this.members = value;
            return this;
        }

        public PlacementHelper build() {
            PlacementHelper result = new PlacementHelper();
            result.source = this.source;
            result.container = this.container;
            result.sections = this.sections;
            result.members = this.members;
            return result;
        }
    }
}

