/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.placement.containers;

import com.exadel.aem.toolkit.api.annotations.main.ClassField;
import com.exadel.aem.toolkit.api.annotations.main.ClassMember;
import com.exadel.aem.toolkit.api.annotations.widgets.accessory.Ignore;
import com.exadel.aem.toolkit.api.annotations.widgets.accessory.IgnoreFields;
import com.exadel.aem.toolkit.api.handlers.MemberSource;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.adapters.ClassMemberSetting;
import com.exadel.aem.toolkit.plugin.exceptions.InvalidContainerException;
import com.exadel.aem.toolkit.plugin.exceptions.InvalidLayoutException;
import com.exadel.aem.toolkit.plugin.handlers.placement.PlacementHelper;
import com.exadel.aem.toolkit.plugin.handlers.placement.registries.MembersRegistry;
import com.exadel.aem.toolkit.plugin.handlers.placement.registries.SectionsRegistry;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.targets.RootTarget;
import com.exadel.aem.toolkit.plugin.utils.ClassUtil;
import com.exadel.aem.toolkit.plugin.utils.ordering.OrderingUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;

abstract class ContainerHandler {
    static final Function<MemberSource, List<Class<?>>> ANNOTATED_MEMBER_TYPE = memberSource -> Collections.singletonList(memberSource.getValueType());
    static final Function<MemberSource, List<Class<?>>> ANNOTATED_MEMBER_TYPE_AND_REPORTING_CLASS = memberSource -> Arrays.asList(memberSource.getValueType(), memberSource.getReportingClass());
    private static final String RECURSION_MESSAGE_TEMPLATE = "Recursive rendering prohibited: a member of type \"%s\" was set to be rendered within a container created with a member of type \"%s\"";

    ContainerHandler() {
    }

    List<Source> getAvailableForContainer(Source host, Target target) {
        ArrayList<Source> result = new ArrayList<Source>();
        MemberSource memberSource = (MemberSource)host.adaptTo(MemberSource.class);
        Class declaringClass = memberSource.getDeclaringClass();
        Class valueTypeClass = memberSource.getValueType();
        if (ClassUtils.isAssignable((Class)valueTypeClass, (Class)declaringClass)) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new InvalidLayoutException(String.format(RECURSION_MESSAGE_TEMPLATE, valueTypeClass.getName(), declaringClass.getName())));
            return Collections.emptyList();
        }
        List<Class<?>> hostsOfRenderedMembers = this.getRenderedClassesProvider().apply(memberSource);
        for (Class<?> hostClass : hostsOfRenderedMembers) {
            boolean isDeclaringClass = hostClass.equals(declaringClass);
            List<ClassMemberSetting> ignoredMembers = ContainerHandler.getIgnoredMembers(memberSource, hostClass);
            Predicate<Source> nonIgnoredMembersFilter = source -> ignoredMembers.stream().noneMatch(ignored -> ignored.matches((Source)source));
            if (isDeclaringClass) {
                nonIgnoredMembersFilter = nonIgnoredMembersFilter.and(source -> !source.isSame(host));
            }
            List<Object> renderedMembers = isDeclaringClass ? ((RootTarget)target.getRoot().adaptTo(RootTarget.class)).getMembers().getAllAvailable().stream().filter(nonIgnoredMembersFilter).collect(Collectors.toList()) : ClassUtil.getSources(hostClass, (MemberSource)host.adaptTo(MemberSource.class), nonIgnoredMembersFilter, false);
            result.addAll(renderedMembers);
        }
        return OrderingUtil.sortMembers(result);
    }

    abstract Function<MemberSource, List<Class<?>>> getRenderedClassesProvider();

    private static List<ClassMemberSetting> getIgnoredMembers(MemberSource container, Class<?> membersHost) {
        Class ignoredMembersHost = container.getReportingClass();
        Stream<Object> classLevelIgnoredMembers = Stream.empty();
        if (ignoredMembersHost.isAnnotationPresent(Ignore.class)) {
            classLevelIgnoredMembers = Arrays.stream(ignoredMembersHost.getAnnotation(Ignore.class).members()).map(memberPtr -> new ClassMemberSetting((ClassMember)memberPtr).populateDefaults(ignoredMembersHost));
        } else if (ignoredMembersHost.isAnnotationPresent(IgnoreFields.class)) {
            classLevelIgnoredMembers = Arrays.stream(ignoredMembersHost.getAnnotation(IgnoreFields.class).value()).map(memberPtr -> new ClassMemberSetting((ClassField)memberPtr).populateDefaults(ignoredMembersHost));
        }
        Stream<Object> memberLevelIgnoredMembers = Stream.empty();
        if (container.adaptTo(Ignore.class) != null) {
            memberLevelIgnoredMembers = Arrays.stream(((Ignore)container.adaptTo(Ignore.class)).members()).map(member -> new ClassMemberSetting((ClassMember)member).populateDefaults(membersHost));
        } else if (container.adaptTo(IgnoreFields.class) != null) {
            memberLevelIgnoredMembers = Arrays.stream(((IgnoreFields)container.adaptTo(IgnoreFields.class)).value()).map(member -> new ClassMemberSetting((ClassField)member).populateDefaults(membersHost));
        }
        return Stream.concat(classLevelIgnoredMembers, memberLevelIgnoredMembers).filter(memberSettings -> ClassUtil.getInheritanceTree(membersHost).stream().anyMatch(superclass -> superclass.equals(memberSettings.getSource()))).collect(Collectors.toList());
    }

    void populateSingleSectionContainer(Source source, List<Source> members, Target target) {
        MembersRegistry membersRegistry = new MembersRegistry(((RootTarget)target.getRoot().adaptTo(RootTarget.class)).getMembers(), members);
        PlacementHelper.builder().source(source).container(target).members(membersRegistry).build().doPlacement();
        ((RootTarget)target.getRoot().adaptTo(RootTarget.class)).getMembers().add(membersRegistry.getAvailable());
    }

    void populateMultiSectionContainer(Source member, Target target) {
        target.createTarget("items");
        SectionsRegistry sectionsRegistry = SectionsRegistry.from(member, target);
        if (sectionsRegistry.getAvailable().isEmpty()) {
            InvalidContainerException ex = new InvalidContainerException();
            PluginRuntime.context().getExceptionHandler().handle((Exception)ex);
        }
        List<Source> placeableMembers = this.getAvailableForContainer(member, target);
        MembersRegistry membersRegistry = new MembersRegistry(((RootTarget)target.getRoot().adaptTo(RootTarget.class)).getMembers(), placeableMembers);
        PlacementHelper.builder().source(member).container(target.getTarget("items")).sections(sectionsRegistry).members(membersRegistry).build().doPlacement();
        ((RootTarget)target.getRoot().adaptTo(RootTarget.class)).getMembers().add(membersRegistry.getAvailable());
    }
}

