/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.placement.containers;

import com.exadel.aem.toolkit.api.annotations.widgets.FieldSet;
import com.exadel.aem.toolkit.api.handlers.Handler;
import com.exadel.aem.toolkit.api.handlers.Handles;
import com.exadel.aem.toolkit.api.handlers.MemberSource;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.exceptions.InvalidLayoutException;
import com.exadel.aem.toolkit.plugin.handlers.Handlers;
import com.exadel.aem.toolkit.plugin.handlers.placement.containers.ContainerHandler;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.sources.Sources;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

@Handles(value={FieldSet.class})
public class FieldSetHandler
extends ContainerHandler
implements Handler {
    private static final String EMPTY_FIELDSET_EXCEPTION_MESSAGE = "No valid fields found in fieldset class ";

    public void accept(Source source, Target target) {
        FieldSet fieldSet = (FieldSet)source.adaptTo(FieldSet.class);
        Class fieldSetType = ((MemberSource)source.adaptTo(MemberSource.class)).getValueType();
        List<Source> fieldSetEntries = this.getAvailableForContainer(source, target);
        if (fieldSetEntries.isEmpty()) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new InvalidLayoutException(EMPTY_FIELDSET_EXCEPTION_MESSAGE + fieldSetType.getName()));
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)fieldSet.namePrefix())) {
            target.namePrefix(fieldSet.namePrefix());
        }
        if (StringUtils.isNotBlank((CharSequence)fieldSet.namePostfix())) {
            target.namePostfix(fieldSet.namePostfix());
        }
        this.populateSingleSectionContainer(source, fieldSetEntries, target);
        Handlers.DATA_ANNOTATIONS_HANDLER.accept(Sources.fromClass(fieldSetType), target);
    }

    @Override
    protected Function<MemberSource, List<Class<?>>> getRenderedClassesProvider() {
        return ANNOTATED_MEMBER_TYPE;
    }
}

