/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.placement.containers;

import com.exadel.aem.toolkit.api.annotations.widgets.MultiField;
import com.exadel.aem.toolkit.api.handlers.Handler;
import com.exadel.aem.toolkit.api.handlers.Handles;
import com.exadel.aem.toolkit.api.handlers.MemberSource;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.exceptions.InvalidLayoutException;
import com.exadel.aem.toolkit.plugin.handlers.Handlers;
import com.exadel.aem.toolkit.plugin.handlers.placement.containers.ContainerHandler;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import java.util.List;
import java.util.function.Function;

@Handles(value={MultiField.class})
public class MultiFieldHandler
extends ContainerHandler
implements Handler {
    private static final String EMPTY_MULTIFIELD_EXCEPTION_MESSAGE = "No valid fields found in multifield class ";

    public void accept(Source source, Target target) {
        String name = (String)target.getAttributes().get("name");
        target.getAttributes().remove("name");
        List<Source> members = this.getAvailableForContainer(source, target);
        if (members.isEmpty()) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new InvalidLayoutException(EMPTY_MULTIFIELD_EXCEPTION_MESSAGE + ((MemberSource)source.adaptTo(MemberSource.class)).getValueType().getName()));
            return;
        }
        if (members.size() > 1 || ((MultiField)source.adaptTo(MultiField.class)).forceComposite()) {
            this.placeMultiple(source, members, target, name);
        } else {
            this.placeOne(members.get(0), target);
        }
    }

    private void placeMultiple(Source source, List<Source> multiFieldEntries, Target target, String name) {
        target.attribute("composite", true);
        Target multifieldContainerElement = target.getOrCreateTarget("field").attribute("name", name).attribute("sling:resourceType", "granite/ui/components/coral/foundation/container");
        this.populateSingleSectionContainer(source, multiFieldEntries, multifieldContainerElement);
    }

    private void placeOne(Source source, Target target) {
        Handlers.forMember().accept(source, target.getOrCreateTarget("field"));
    }

    @Override
    protected Function<MemberSource, List<Class<?>>> getRenderedClassesProvider() {
        return ANNOTATED_MEMBER_TYPE;
    }
}

