/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.placement.layouts;

import com.exadel.aem.toolkit.api.annotations.layouts.AccordionPanel;
import com.exadel.aem.toolkit.api.annotations.layouts.Column;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.adapters.PlaceSetting;
import com.exadel.aem.toolkit.plugin.exceptions.InvalidContainerException;
import com.exadel.aem.toolkit.plugin.handlers.placement.PlacementHelper;
import com.exadel.aem.toolkit.plugin.handlers.placement.registries.MembersRegistry;
import com.exadel.aem.toolkit.plugin.handlers.placement.registries.SectionsRegistry;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.targets.RootTarget;
import com.exadel.aem.toolkit.plugin.utils.ClassUtil;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;

interface ComplexLayoutHandler
extends BiConsumer<Source, Target> {
    default public void doLayout(Source source, Target target, Class<? extends Annotation> annotationType) {
        this.doLayout(source, target, Collections.singletonList(annotationType));
    }

    default public void doLayout(Source source, Target target, List<Class<? extends Annotation>> annotationTypes) {
        String resourceType;
        String containerTag;
        SectionsRegistry sectionsRegistry = SectionsRegistry.from(source, target, annotationTypes);
        MembersRegistry membersRegistry = new MembersRegistry(ClassUtil.getSources((Class)source.adaptTo(Class.class)));
        ((RootTarget)target.adaptTo(RootTarget.class)).setMembers(membersRegistry);
        if (sectionsRegistry.getAvailable().isEmpty() && !membersRegistry.getAvailable().isEmpty()) {
            InvalidContainerException ex = new InvalidContainerException();
            PluginRuntime.context().getExceptionHandler().handle((Exception)ex);
        }
        if (annotationTypes.contains(Column.class)) {
            containerTag = "fixedColumns";
            resourceType = "granite/ui/components/coral/foundation/fixedcolumns";
        } else if (annotationTypes.contains(AccordionPanel.class)) {
            containerTag = "accordion";
            resourceType = "granite/ui/components/coral/foundation/accordion";
        } else {
            containerTag = "tabs";
            resourceType = "granite/ui/components/coral/foundation/tabs";
        }
        Target itemsContainer = target.createTarget("content").attribute("sling:resourceType", "granite/ui/components/coral/foundation/container").createTarget("items").createTarget(containerTag).attribute("sling:resourceType", resourceType).createTarget("items");
        PlacementHelper.builder().container(itemsContainer).sections(sectionsRegistry).members(membersRegistry).build().doPlacement();
        for (Source unplaced : membersRegistry.getAvailable()) {
            String placeValue = ((PlaceSetting)unplaced.adaptTo(PlaceSetting.class)).getValue();
            InvalidContainerException ex = new InvalidContainerException(placeValue);
            PluginRuntime.context().getExceptionHandler().handle((Exception)ex);
        }
    }
}

