/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.placement.registries;

import com.exadel.aem.toolkit.api.annotations.layouts.Accordion;
import com.exadel.aem.toolkit.api.annotations.layouts.FixedColumns;
import com.exadel.aem.toolkit.api.annotations.layouts.Place;
import com.exadel.aem.toolkit.api.annotations.layouts.Tabs;
import com.exadel.aem.toolkit.api.handlers.MemberSource;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.handlers.placement.registries.SectionsRegistry;
import com.exadel.aem.toolkit.plugin.handlers.placement.sections.Section;
import com.exadel.aem.toolkit.plugin.sources.Sources;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class ContainerSectionsRegistry
extends SectionsRegistry {
    private static final Predicate<Target> CONTAINER_PREDICATE = node -> "granite/ui/components/coral/foundation/container".equals(node.getAttribute("sling:resourceType"));
    private static final Predicate<Target> WIDGET_NODE_PREDICATE = node -> !node.getAttribute("sling:resourceType", "").isEmpty();

    ContainerSectionsRegistry(Source source, Target target) {
        super(ContainerSectionsRegistry.collectSections(source, ContainerSectionsRegistry.getTitlePrefix(source, target)), ContainerSectionsRegistry.collectIgnoredSections(source));
    }

    private static List<Section> collectSections(Source source, String titlePrefix) {
        if (source == null) {
            return Collections.emptyList();
        }
        if (source.tryAdaptTo(Tabs.class).isPresent()) {
            return Arrays.stream(((Tabs)source.adaptTo(Tabs.class)).value()).map(tab -> {
                Section newSection = Section.from(tab, false);
                newSection.setTitlePrefix(titlePrefix);
                return newSection;
            }).collect(Collectors.toList());
        }
        if (source.tryAdaptTo(Accordion.class).isPresent()) {
            return Arrays.stream(((Accordion)source.adaptTo(Accordion.class)).value()).map(accordionPanel -> {
                Section newSection = Section.from(accordionPanel, false);
                newSection.setTitlePrefix(titlePrefix);
                return newSection;
            }).collect(Collectors.toList());
        }
        if (source.tryAdaptTo(FixedColumns.class).isPresent()) {
            return Arrays.stream(((FixedColumns)source.adaptTo(FixedColumns.class)).value()).map(column -> {
                Section newSection = Section.from(column, false);
                newSection.setTitlePrefix(titlePrefix);
                return newSection;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static String getTitlePrefix(Source source, Target target) {
        Place placeSetting = (Place)source.adaptTo(Place.class);
        if (placeSetting != null && StringUtils.isNotBlank((CharSequence)placeSetting.value())) {
            return placeSetting.value();
        }
        ArrayList<String> resultChunks = new ArrayList<String>();
        Target closestContainer = target.findParent(CONTAINER_PREDICATE);
        while (closestContainer != null) {
            boolean isContainerWidget;
            Target closestWidgetNode = closestContainer.findParent(WIDGET_NODE_PREDICATE);
            boolean bl = isContainerWidget = closestWidgetNode != null && StringUtils.equalsAny((CharSequence)closestWidgetNode.getAttribute("sling:resourceType"), (CharSequence[])new CharSequence[]{"granite/ui/components/coral/foundation/accordion", "granite/ui/components/coral/foundation/tabs", "granite/ui/components/coral/foundation/fixedcolumns"});
            if (!isContainerWidget) break;
            resultChunks.add(0, closestContainer.getAttribute("jcr:title", ""));
            closestContainer = closestWidgetNode.findParent(CONTAINER_PREDICATE);
        }
        return String.join((CharSequence)"/", resultChunks);
    }

    private static List<String> collectIgnoredSections(Source source) {
        HashSet<String> result = new HashSet<String>(ContainerSectionsRegistry.collectIgnored(source));
        result.addAll(ContainerSectionsRegistry.collectIgnored(Sources.fromClass(((MemberSource)source.adaptTo(MemberSource.class)).getReportingClass())));
        return new ArrayList<String>(result);
    }
}

