/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.placement.registries;

import com.exadel.aem.toolkit.api.annotations.layouts.Accordion;
import com.exadel.aem.toolkit.api.annotations.layouts.FixedColumns;
import com.exadel.aem.toolkit.api.annotations.layouts.Tabs;
import com.exadel.aem.toolkit.api.annotations.main.Dialog;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.handlers.placement.registries.SectionsRegistry;
import com.exadel.aem.toolkit.plugin.handlers.placement.sections.Section;
import com.exadel.aem.toolkit.plugin.utils.ClassUtil;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

class DialogSectionsRegistry
extends SectionsRegistry {
    DialogSectionsRegistry(Source source, Target target, List<Class<? extends Annotation>> annotationTypes) {
        super(DialogSectionsRegistry.collectSections((Class)source.adaptTo(Class.class), target.getScope(), annotationTypes), DialogSectionsRegistry.collectIgnored(source));
    }

    private static List<Section> collectSections(Class<?> componentClass, String scope, List<Class<? extends Annotation>> annotationTypes) {
        List<Section> containerSectionsFromSuperClasses = DialogSectionsRegistry.collectSections(ClassUtil.getInheritanceTree(componentClass, false), scope, annotationTypes);
        List<Section> containerSectionsFromCurrentClass = DialogSectionsRegistry.collectSections(Collections.singletonList(componentClass), scope, annotationTypes);
        return DialogSectionsRegistry.mergeSectionsFromCurrentClassAndSuperclasses(containerSectionsFromCurrentClass, containerSectionsFromSuperClasses);
    }

    private static List<Section> collectSections(List<Class<?>> hierarchy, String scope, List<Class<? extends Annotation>> annotationTypes) {
        ArrayList<Section> result = new ArrayList<Section>();
        for (Class<?> classEntry : hierarchy) {
            DialogSectionsRegistry.appendSectionsFromNestedClasses(result, classEntry, annotationTypes);
            DialogSectionsRegistry.appendSectionsFromCurrentClass(result, classEntry, scope);
        }
        return result;
    }

    private static void appendSectionsFromNestedClasses(List<Section> accumulator, Class<?> componentClass, List<Class<? extends Annotation>> annotationTypes) {
        List nestedClasses = Arrays.stream(componentClass.getDeclaredClasses()).filter(nestedCls -> annotationTypes.stream().anyMatch(nestedCls::isAnnotationPresent)).collect(Collectors.toList());
        Collections.reverse(nestedClasses);
        for (Class nestedClass : nestedClasses) {
            Annotation matchedAnnotation = annotationTypes.stream().filter(nestedClass::isAnnotationPresent).findFirst().map(nestedClass::getDeclaredAnnotation).orElse(null);
            Section section = Section.from(matchedAnnotation, true);
            if (section == null) continue;
            section.getSources().addAll(ClassUtil.getSources(nestedClass));
            accumulator.add(section);
        }
    }

    private static void appendSectionsFromCurrentClass(List<Section> accumulator, Class<?> componentClass, String scope) {
        Object[] legacyTabs = null;
        Object[] tabs = null;
        Object[] panels = null;
        Object[] columns = null;
        if ("_cq_dialog.xml".equals(scope) && componentClass.getDeclaredAnnotation(Dialog.class) != null) {
            Dialog dialogAnnotation = componentClass.getDeclaredAnnotation(Dialog.class);
            legacyTabs = dialogAnnotation.tabs();
        }
        if (componentClass.getDeclaredAnnotation(Tabs.class) != null) {
            tabs = componentClass.getDeclaredAnnotation(Tabs.class).value();
        } else if (componentClass.getDeclaredAnnotation(Accordion.class) != null) {
            panels = componentClass.getDeclaredAnnotation(Accordion.class).value();
        } else if (componentClass.getDeclaredAnnotation(FixedColumns.class) != null) {
            columns = componentClass.getDeclaredAnnotation(FixedColumns.class).value();
        }
        Stream.of(ArrayUtils.nullToEmpty((Object[])legacyTabs), ArrayUtils.nullToEmpty((Object[])tabs), ArrayUtils.nullToEmpty((Object[])panels), ArrayUtils.nullToEmpty((Object[])columns)).flatMap(Arrays::stream).forEach(section -> accumulator.add(Section.from((Annotation)section, true)));
    }

    private static List<Section> mergeSectionsFromCurrentClassAndSuperclasses(List<Section> sectionsFromCurrentClass, List<Section> sectionsFromSuperClasses) {
        boolean sectionTitlesIntersect = sectionsFromCurrentClass.stream().anyMatch(section -> sectionsFromSuperClasses.stream().anyMatch(otherSection -> otherSection.getTitle().equals(section.getTitle())));
        if (sectionTitlesIntersect) {
            return DialogSectionsRegistry.mergeSections(sectionsFromCurrentClass, sectionsFromSuperClasses);
        }
        return DialogSectionsRegistry.mergeSections(sectionsFromSuperClasses, sectionsFromCurrentClass);
    }

    private static List<Section> mergeSections(List<Section> primary, List<Section> secondary) {
        ArrayList<Section> result = new ArrayList<Section>(primary);
        for (Section other : secondary) {
            Section matchingFromCurrentClass = result.stream().filter(section -> section.getTitle().equals(other.getTitle())).findFirst().orElse(null);
            if (matchingFromCurrentClass != null) {
                matchingFromCurrentClass.merge(other);
                continue;
            }
            result.add(other);
        }
        return result;
    }
}

