/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.placement.registries;

import com.exadel.aem.toolkit.api.handlers.Source;
import java.util.List;
import java.util.stream.Collectors;

public class MembersRegistry {
    private final List<Entry> entries;

    public MembersRegistry(List<Source> members) {
        this(null, members);
    }

    public MembersRegistry(MembersRegistry upstream, List<Source> members) {
        this.entries = members.stream().map(member -> MembersRegistry.findMatchOrCreate(upstream, member)).collect(Collectors.toList());
    }

    public List<Source> getAvailable() {
        return this.entries.stream().filter(entry -> entry.getState() == EntryState.AVAILABLE).map(Entry::getMember).collect(Collectors.toList());
    }

    public List<Source> getAllAvailable() {
        return this.entries.stream().filter(entry -> entry.getState() == EntryState.AVAILABLE || entry.getState() == EntryState.SOFT_CHECKED_OUT).map(Entry::getMember).collect(Collectors.toList());
    }

    public void add(List<Source> members) {
        List additionalEntries = members.stream().filter(member -> this.entries.stream().noneMatch(entry -> entry.isSameMember((Source)member))).map(Entry::new).collect(Collectors.toList());
        this.entries.addAll(additionalEntries);
    }

    public void checkOut(Source member) {
        this.entries.stream().filter(entry -> entry.getMember().equals(member)).findFirst().ifPresent(entry -> entry.setState(EntryState.CHECKED_OUT));
    }

    public void softCheckOut(Source member) {
        this.entries.stream().filter(entry -> entry.getMember().equals(member)).findFirst().ifPresent(entry -> entry.setState(EntryState.SOFT_CHECKED_OUT));
    }

    private static Entry findMatchOrCreate(MembersRegistry upstream, Source member) {
        if (upstream == null) {
            return new Entry(member);
        }
        Entry match = upstream.entries.stream().filter(entry -> ((Entry)entry).member.equals(member)).findFirst().orElse(null);
        if (match != null) {
            return match;
        }
        return new Entry(member);
    }

    private static enum EntryState {
        AVAILABLE,
        SOFT_CHECKED_OUT,
        CHECKED_OUT;

    }

    private static class Entry {
        private final Source member;
        private EntryState state;

        Entry(Source member) {
            this.member = member;
            this.state = EntryState.AVAILABLE;
        }

        public Source getMember() {
            return this.member;
        }

        public EntryState getState() {
            return this.state;
        }

        public void setState(EntryState state) {
            this.state = state;
        }

        public boolean isSameMember(Source other) {
            if (this.getMember() == null) {
                return false;
            }
            return this.getMember().isSame(other);
        }
    }
}

