/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.placement.registries;

import com.exadel.aem.toolkit.api.annotations.container.IgnoreTabs;
import com.exadel.aem.toolkit.api.annotations.layouts.Accordion;
import com.exadel.aem.toolkit.api.annotations.layouts.FixedColumns;
import com.exadel.aem.toolkit.api.annotations.layouts.Tabs;
import com.exadel.aem.toolkit.api.annotations.widgets.accessory.Ignore;
import com.exadel.aem.toolkit.api.handlers.MemberSource;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.handlers.placement.registries.ContainerSectionsRegistry;
import com.exadel.aem.toolkit.plugin.handlers.placement.registries.DialogSectionsRegistry;
import com.exadel.aem.toolkit.plugin.handlers.placement.sections.Section;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public abstract class SectionsRegistry {
    private final List<Section> sections;

    SectionsRegistry(List<Section> availableSections, List<String> ignoredSections) {
        this.sections = new ArrayList<Section>(availableSections);
        for (String ignoredTitle : ignoredSections) {
            this.sections.stream().filter(section -> section.isMatch(ignoredTitle)).findFirst().ifPresent(this.sections::remove);
            this.sections.add(Section.ignored(ignoredTitle));
        }
    }

    public List<Section> getAvailable() {
        return this.sections;
    }

    public static boolean isAvailableFor(Source source) {
        if (!(source instanceof MemberSource)) {
            return false;
        }
        return Stream.of(Tabs.class, Accordion.class, FixedColumns.class).anyMatch(sectionType -> source.tryAdaptTo(sectionType).isPresent());
    }

    static List<String> collectIgnored(Source source) {
        ArrayList<String> result = new ArrayList<String>();
        if (source.tryAdaptTo(IgnoreTabs.class).isPresent()) {
            result.addAll(Arrays.asList(((IgnoreTabs)source.adaptTo(IgnoreTabs.class)).value()));
        }
        if (source.tryAdaptTo(Ignore.class).isPresent() && ((Ignore)source.adaptTo(Ignore.class)).sections().length > 0) {
            result.addAll(Arrays.asList(((Ignore)source.adaptTo(Ignore.class)).sections()));
        }
        return result;
    }

    public static SectionsRegistry from(Source source, Target target, List<Class<? extends Annotation>> annotationTypes) {
        return new DialogSectionsRegistry(source, target, annotationTypes);
    }

    public static SectionsRegistry from(Source source, Target target) {
        return new ContainerSectionsRegistry(source, target);
    }
}

