/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.placement.sections;

import com.exadel.aem.toolkit.api.annotations.container.Tab;
import com.exadel.aem.toolkit.api.annotations.widgets.attribute.Attribute;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.handlers.placement.sections.Section;
import com.exadel.aem.toolkit.plugin.metadata.RenderingFilter;
import com.exadel.aem.toolkit.plugin.utils.NamingUtil;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.function.Predicate;

class LegacyTabSection
extends Section {
    private final Tab tab;

    LegacyTabSection(Tab tab, boolean isLayout) {
        super(isLayout);
        this.tab = tab;
    }

    @Override
    public String getTitle() {
        if (this.tab == null) {
            return "";
        }
        return this.tab.title();
    }

    @Override
    public Target createItemsContainer(Target host) {
        if (this.tab == null) {
            return host;
        }
        String nodeName = NamingUtil.getUniqueName(this.getTitle(), "tab", host);
        Target itemsContainer = host.createTarget(nodeName);
        itemsContainer.attribute("sling:resourceType", "granite/ui/components/coral/foundation/container").attribute("jcr:title", this.getTitle());
        Attribute attributeAnnotation = this.tab.attribute();
        itemsContainer.attributes((Annotation)attributeAnnotation, (Predicate)new RenderingFilter((Annotation)attributeAnnotation));
        if (attributeAnnotation.data().length > 0) {
            Target graniteDataElement = host.getOrCreateTarget("granite:data");
            Arrays.stream(attributeAnnotation.data()).forEach(data -> graniteDataElement.attribute(data.name(), data.value()));
        }
        return itemsContainer;
    }
}

