/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.placement.sections;

import com.exadel.aem.toolkit.api.annotations.layouts.AccordionPanel;
import com.exadel.aem.toolkit.api.annotations.layouts.Column;
import com.exadel.aem.toolkit.api.annotations.layouts.Tab;
import com.exadel.aem.toolkit.api.handlers.MemberSource;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.adapters.PlaceSetting;
import com.exadel.aem.toolkit.plugin.handlers.placement.sections.AccordionPanelSection;
import com.exadel.aem.toolkit.plugin.handlers.placement.sections.ColumnSection;
import com.exadel.aem.toolkit.plugin.handlers.placement.sections.IgnoredSection;
import com.exadel.aem.toolkit.plugin.handlers.placement.sections.LegacyTabSection;
import com.exadel.aem.toolkit.plugin.handlers.placement.sections.TabSection;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class Section {
    private final List<Source> sources;
    private final boolean isLayout;
    private String titlePrefix;

    Section(boolean isLayout) {
        this.isLayout = isLayout;
        this.sources = new ArrayList<Source>();
    }

    public abstract String getTitle();

    public void setTitlePrefix(String value) {
        this.titlePrefix = value;
    }

    private String getFullTitle() {
        return StringUtils.stripEnd((String)StringUtils.defaultString((String)this.titlePrefix), (String)"/") + "/" + this.getTitle();
    }

    boolean isLayout() {
        return this.isLayout;
    }

    public boolean isIgnored() {
        return false;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public void merge(Section other) {
        this.sources.addAll(other.getSources());
    }

    public boolean isMatch(String title) {
        return StringUtils.equalsAny((CharSequence)title, (CharSequence[])new CharSequence[]{this.getTitle(), this.getFullTitle()});
    }

    public boolean canContain(Source member) {
        return this.canContain(member, false);
    }

    public boolean canContain(Source member, boolean allowUndefined) {
        if (!(member instanceof MemberSource)) {
            return false;
        }
        if (!member.tryAdaptTo(PlaceSetting.class).isPresent()) {
            return this.isLayout && allowUndefined;
        }
        String placeValue = StringUtils.strip((String)((PlaceSetting)member.adaptTo(PlaceSetting.class)).getValue(), (String)"/");
        return StringUtils.equals((CharSequence)placeValue, (CharSequence)this.getTitle()) || StringUtils.equals((CharSequence)placeValue, (CharSequence)this.getFullTitle()) || StringUtils.isBlank((CharSequence)placeValue) && this.isLayout && allowUndefined;
    }

    public abstract Target createItemsContainer(Target var1);

    public static Section from(Annotation value, boolean isLayout) {
        if (value == null) {
            return null;
        }
        if (value.annotationType().equals(Tab.class)) {
            return Section.from((Tab)value, isLayout);
        }
        if (value.annotationType().equals(com.exadel.aem.toolkit.api.annotations.container.Tab.class)) {
            return Section.from((com.exadel.aem.toolkit.api.annotations.container.Tab)value, isLayout);
        }
        if (value.annotationType().equals(AccordionPanel.class)) {
            return Section.from((AccordionPanel)value, isLayout);
        }
        if (value.annotationType().equals(Column.class)) {
            return Section.from((Column)value, isLayout);
        }
        return null;
    }

    public static Section from(Tab value, boolean isLayout) {
        if (value == null) {
            return null;
        }
        return new TabSection(value, isLayout);
    }

    public static Section from(com.exadel.aem.toolkit.api.annotations.container.Tab value, boolean isLayout) {
        if (value == null) {
            return null;
        }
        return new LegacyTabSection(value, isLayout);
    }

    public static Section from(AccordionPanel value, boolean isLayout) {
        if (value == null) {
            return null;
        }
        return new AccordionPanelSection(value, isLayout);
    }

    public static Section from(Column value, boolean isLayout) {
        if (value == null) {
            return null;
        }
        return new ColumnSection(value, isLayout);
    }

    public static Section ignored(String title) {
        return new IgnoredSection(title);
    }
}

