/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.placement.sections;

import com.exadel.aem.toolkit.api.annotations.layouts.Tab;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.handlers.placement.sections.Section;
import com.exadel.aem.toolkit.plugin.targets.Targets;
import com.exadel.aem.toolkit.plugin.utils.NamingUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

class TabSection
extends Section {
    private static final Predicate<Method> MAIN_NODE_MEMBERS = method -> StringUtils.equalsAny((CharSequence)method.getName(), (CharSequence[])new CharSequence[]{"title", "trackingElement"});
    private final Tab tab;

    TabSection(Tab tab, boolean isLayout) {
        super(isLayout);
        this.tab = tab;
    }

    @Override
    public String getTitle() {
        if (this.tab == null) {
            return "";
        }
        return this.tab.title();
    }

    @Override
    public Target createItemsContainer(Target host) {
        if (this.tab == null) {
            return host;
        }
        String nodeName = NamingUtil.getUniqueName(this.getTitle(), "tab", host);
        Target itemsContainer = host.createTarget(nodeName);
        itemsContainer.attribute("sling:resourceType", "granite/ui/components/coral/foundation/container").attributes((Annotation)this.tab, MAIN_NODE_MEMBERS);
        String configContainerTag = this.isLayout() ? "layoutConfig" : "parentConfig";
        Target configContainer = Targets.newTarget(configContainerTag).attributes((Annotation)this.tab, MAIN_NODE_MEMBERS.negate());
        if (!configContainer.isEmpty()) {
            itemsContainer.addTarget(configContainer);
        }
        return itemsContainer;
    }
}

