/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.widgets;

import com.exadel.aem.toolkit.api.annotations.widgets.Checkbox;
import com.exadel.aem.toolkit.api.annotations.widgets.DialogField;
import com.exadel.aem.toolkit.api.handlers.Handler;
import com.exadel.aem.toolkit.api.handlers.Handles;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.metadata.RenderingFilter;
import com.exadel.aem.toolkit.plugin.utils.ClassUtil;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

@Handles(value={Checkbox.class})
public class CheckboxHandler
implements Handler {
    private static final String POSTFIX_FOR_ROOT_CHECKBOX = "Checkbox";

    public void accept(Source source, Target target) {
        Checkbox checkbox = (Checkbox)source.adaptTo(Checkbox.class);
        RenderingFilter mappingFilter = new RenderingFilter((Annotation)checkbox);
        if (ArrayUtils.isEmpty((Object[])checkbox.sublist())) {
            target.attributes((Annotation)checkbox, (Predicate)mappingFilter);
            this.setTextAttribute(source, target);
        } else {
            Target checkboxElement = target.attribute("sling:resourceType", "granite/ui/components/coral/foundation/form/nestedcheckboxlist").getOrCreateTarget("items").getOrCreateTarget(source.getName() + POSTFIX_FOR_ROOT_CHECKBOX).attribute("sling:resourceType", "granite/ui/components/coral/foundation/form/checkbox").attributes((Annotation)checkbox, (Predicate)mappingFilter);
            this.appendNestedCheckBoxList(source, checkboxElement);
        }
    }

    private void appendNestedCheckBoxList(Source source, Target target) {
        Target itemsElement = target.getOrCreateTarget("sublist").attribute("sling:resourceType", "granite/ui/components/coral/foundation/form/nestedcheckboxlist").attribute("disconnected", ((Checkbox)source.adaptTo(Checkbox.class)).disconnectedSublist()).getOrCreateTarget("items");
        this.appendCheckbox(source, itemsElement);
    }

    private void appendCheckbox(Source source, Target target) {
        Checkbox checkbox = (Checkbox)source.adaptTo(Checkbox.class);
        for (Class sublistClass : checkbox.sublist()) {
            List sources = ClassUtil.getSources(sublistClass).stream().filter(f -> f.adaptTo(Checkbox.class) != null).collect(Collectors.toList());
            for (Source innerSource : sources) {
                Checkbox innerCheckbox = (Checkbox)innerSource.adaptTo(Checkbox.class);
                Target checkboxElement = target.getOrCreateTarget(innerSource.getName()).attribute("sling:resourceType", "granite/ui/components/coral/foundation/form/checkbox").attributes((Annotation)innerCheckbox, (Predicate)new RenderingFilter((Annotation)innerCheckbox));
                this.setTextAttribute(innerSource, checkboxElement);
                if (!ArrayUtils.isNotEmpty((Object[])((Checkbox)innerSource.adaptTo(Checkbox.class)).sublist())) continue;
                this.appendNestedCheckBoxList(innerSource, checkboxElement);
            }
        }
    }

    private void setTextAttribute(Source source, Target target) {
        Checkbox checkbox = (Checkbox)source.adaptTo(Checkbox.class);
        if (checkbox.text().isEmpty() && source.adaptTo(DialogField.class) != null) {
            target.attribute("text", ((DialogField)source.adaptTo(DialogField.class)).label());
        } else if (checkbox.text().isEmpty()) {
            target.attribute("text", source.getName());
        }
    }
}

