/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.widgets;

import com.exadel.aem.toolkit.api.annotations.widgets.color.ColorField;
import com.exadel.aem.toolkit.api.handlers.Handler;
import com.exadel.aem.toolkit.api.handlers.Handles;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@Handles(value={ColorField.class})
public class ColorFieldHandler
implements Handler {
    private static final String NODE_NAME_COLOR = "color";
    private static final String SKIPPED_COLOR_NODE_NAME_SYMBOLS = "^\\w+";

    public void accept(Source source, Target target) {
        List<String> validCustomColors;
        ColorField colorField = (ColorField)source.adaptTo(ColorField.class);
        List<String> list = validCustomColors = ArrayUtils.isNotEmpty((Object[])colorField.customColors()) ? Arrays.stream(colorField.customColors()).filter(StringUtils::isNotBlank).collect(Collectors.toList()) : Collections.emptyList();
        if (validCustomColors.isEmpty()) {
            return;
        }
        Target itemsNode = target.getOrCreateTarget("items");
        for (String customColor : validCustomColors) {
            itemsNode.getOrCreateTarget(NODE_NAME_COLOR + customColor.toLowerCase().replace(SKIPPED_COLOR_NODE_NAME_SYMBOLS, "")).attribute("jcr:primaryType", "nt:unstructured").attributes(Collections.singletonMap("value", customColor));
        }
    }
}

