/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.widgets;

import com.exadel.aem.toolkit.api.annotations.widgets.common.TypeHint;
import com.exadel.aem.toolkit.api.annotations.widgets.datepicker.DatePicker;
import com.exadel.aem.toolkit.api.annotations.widgets.datepicker.DateTimeValue;
import com.exadel.aem.toolkit.api.handlers.Handler;
import com.exadel.aem.toolkit.api.handlers.Handles;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.adapters.DateTimeSetting;
import com.exadel.aem.toolkit.plugin.exceptions.ValidationException;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import com.exadel.aem.toolkit.plugin.validators.Validation;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@Handles(value={DatePicker.class})
public class DatePickerHandler
implements Handler {
    private static final String INVALID_FORMAT_EXCEPTION_TEMPLATE = "Invalid %s '%s' for @DatePicker field '%s'";
    private static final String INVALID_VALUE_EXCEPTION_TEMPLATE = "Property '%s' of @DatePicker does not correspond to the specified value format";

    public void accept(Source source, Target target) {
        DatePicker datePicker = (DatePicker)source.adaptTo(DatePicker.class);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_DATE_TIME;
        if (datePicker.typeHint() == TypeHint.STRING) {
            target.attribute("typeHint", datePicker.typeHint().toString());
        } else if (datePicker.typeHint() != TypeHint.NONE) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ValidationException(INVALID_FORMAT_EXCEPTION_TEMPLATE, "typeHint", datePicker.typeHint(), target.getName()));
            return;
        }
        if (datePicker.typeHint() == TypeHint.STRING && !StringUtils.isEmpty((CharSequence)datePicker.valueFormat())) {
            try {
                String patchedValueFormat = datePicker.valueFormat().replaceAll("\\bD{1,2}\\b", "dd").replaceAll("\\W*([TZ])\\W*", "'$1'");
                dateTimeFormatter = DateTimeFormatter.ofPattern(patchedValueFormat);
            }
            catch (IllegalArgumentException e) {
                PluginRuntime.context().getExceptionHandler().handle((Exception)new ValidationException(INVALID_FORMAT_EXCEPTION_TEMPLATE, "valueFormat", datePicker.valueFormat(), target.getName()));
                return;
            }
        }
        Validation.forProperty(Metadata.from(datePicker).getProperty("minDate")).test(datePicker.minDate());
        Validation.forProperty(Metadata.from(datePicker).getProperty("maxDate")).test(datePicker.maxDate());
        this.storeDateValue(datePicker.minDate(), target, "minDate", dateTimeFormatter);
        this.storeDateValue(datePicker.maxDate(), target, "maxDate", dateTimeFormatter);
    }

    private void storeDateValue(DateTimeValue value, Target target, String attribute, DateTimeFormatter formatter) {
        DateTimeSetting dateTimeSetting = new DateTimeSetting(value);
        if (dateTimeSetting.isEmpty()) {
            return;
        }
        try {
            target.attribute(attribute, formatter.format(Objects.requireNonNull(dateTimeSetting.getTemporal())));
        }
        catch (NullPointerException | DateTimeException e) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ValidationException(INVALID_VALUE_EXCEPTION_TEMPLATE, attribute));
        }
    }
}

