/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.widgets;

import com.exadel.aem.toolkit.api.annotations.meta.StringTransformation;
import com.exadel.aem.toolkit.api.annotations.widgets.DataSource;
import com.exadel.aem.toolkit.api.annotations.widgets.common.OptionProvider;
import com.exadel.aem.toolkit.api.annotations.widgets.common.OptionSource;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.api.markers._Default;
import com.exadel.aem.toolkit.core.optionprovider.utils.PatternUtil;
import com.exadel.aem.toolkit.plugin.exceptions.ExtensionApiException;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import com.exadel.aem.toolkit.plugin.metadata.RenderingFilter;
import com.exadel.aem.toolkit.plugin.utils.ArrayUtil;
import com.exadel.aem.toolkit.plugin.utils.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

abstract class OptionProviderHandler {
    private static final String RESOURCE_TYPE_PREFIX = "/apps/";
    private static final String PN_FALLBACK = "fallback";
    private static final String PROPERTY_IS_FALLBACK = "isFallback";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    OptionProviderHandler() {
    }

    void appendDataSourceData(DataSource dataSource, Target target) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{dataSource.path(), dataSource.resourceType()})) {
            return;
        }
        Target datasourceElement = target.getOrCreateTarget("datasource").attribute("sling:resourceType", dataSource.resourceType());
        if (StringUtils.isNotBlank((CharSequence)dataSource.path())) {
            datasourceElement.attribute("path", dataSource.path());
        }
        Arrays.stream(dataSource.properties()).forEach(property -> datasourceElement.attribute(property.name(), property.value()));
    }

    void appendOption(Annotation option, String optionValue, Target parentElement) {
        List existing = parentElement.findChildren(t -> t.getAttribute("value").equals(optionValue));
        Target item = existing.isEmpty() ? parentElement.createTarget("\"" + optionValue + "\"") : parentElement.getTarget("\"" + optionValue + "\"");
        item.attributes(option, (Predicate)new RenderingFilter(option));
    }

    boolean hasProvidedOptions(OptionProvider optionProvider) {
        boolean hasExternalOptions = ArrayUtils.isNotEmpty((Object[])optionProvider.value()) && Arrays.stream(optionProvider.value()).anyMatch(optionSource -> StringUtils.isNotBlank((CharSequence)optionSource.value()) || !optionSource.enumeration().equals(_Default.class));
        boolean hasPrependedOptions = ArrayUtils.isNotEmpty((Object[])optionProvider.prepend()) && Arrays.stream(optionProvider.prepend()).anyMatch(StringUtils::isNotEmpty);
        boolean hasAppendedOptions = ArrayUtils.isNotEmpty((Object[])optionProvider.append()) && Arrays.stream(optionProvider.append()).anyMatch(StringUtils::isNotEmpty);
        return hasExternalOptions || hasPrependedOptions || hasAppendedOptions;
    }

    void appendOptionProvider(OptionProvider optionProvider, Target target) {
        Target datasourceElement = target.getOrCreateTarget("datasource").attribute("sling:resourceType", "/apps/etoolbox-authoring-kit/datasources/option-provider").attributes((Annotation)optionProvider, (Predicate)new RenderingFilter((Annotation)optionProvider));
        if (ArrayUtils.isNotEmpty((Object[])optionProvider.prepend())) {
            datasourceElement.attribute("prepend", ArrayUtil.flatten(optionProvider.prepend()));
        }
        if (ArrayUtils.isNotEmpty((Object[])optionProvider.append())) {
            datasourceElement.attribute("append", ArrayUtil.flatten(optionProvider.append()));
        }
        int pathItemOrdinal = 1;
        List effectiveSources = Arrays.stream(optionProvider.value()).flatMap(OptionProviderHandler::splitMainAndFallback).collect(Collectors.toList());
        for (OptionSource item : effectiveSources) {
            String pathPostfix = optionProvider.value().length > 1 ? Integer.toString(pathItemOrdinal++) : "";
            OptionProviderHandler.populateOptionSourceAttributes(item, datasourceElement, pathPostfix);
        }
    }

    private static Stream<OptionSource> splitMainAndFallback(OptionSource original) {
        if (StringUtils.isBlank((CharSequence)original.fallback())) {
            return Stream.of(original);
        }
        Metadata newInstance = Metadata.from(original);
        newInstance.putValue("value", (Object)original.fallback());
        newInstance.putValue(PROPERTY_IS_FALLBACK, (Object)true);
        return Stream.of(original, (OptionSource)newInstance);
    }

    private static void populateOptionSourceAttributes(OptionSource optionSource, Target element, String postfix) {
        if (StringUtils.isNotBlank((CharSequence)optionSource.value())) {
            element.attribute("path" + postfix, optionSource.value());
        } else if (!optionSource.enumeration().equals(_Default.class)) {
            element.attribute("path" + postfix, OptionProviderHandler.extractOptions(optionSource.enumeration(), optionSource));
        }
        OptionProviderHandler.setAttribute(StringUtils.isNotBlank((CharSequence)optionSource.textMember()), element, "textMember" + postfix, optionSource.textMember());
        OptionProviderHandler.setAttribute(StringUtils.isNotBlank((CharSequence)optionSource.valueMember()), element, "valueMember" + postfix, optionSource.valueMember());
        OptionProviderHandler.setAttribute(ArrayUtils.isNotEmpty((Object[])optionSource.attributeMembers()), element, "attributeMembers" + postfix, StringUtil.format(optionSource.attributeMembers(), String.class));
        OptionProviderHandler.setAttribute(ArrayUtils.isNotEmpty((Object[])optionSource.attributes()), element, "attributes" + postfix, optionSource.attributes());
        OptionProviderHandler.setAttribute(!optionSource.textTransform().equals((Object)StringTransformation.NONE), element, "textTransform" + postfix, optionSource.textTransform().toString().toLowerCase());
        OptionProviderHandler.setAttribute(!optionSource.valueTransform().equals((Object)StringTransformation.NONE), element, "valueTransform" + postfix, optionSource.valueTransform().toString().toLowerCase());
        if (optionSource.isFallback()) {
            element.attribute(PN_FALLBACK + postfix, true);
        }
    }

    private static void setAttribute(boolean condition, Target element, String name, String value) {
        if (condition) {
            element.attribute(name, value);
        }
    }

    private static void setAttribute(boolean condition, Target element, String name, String[] value) {
        if (condition) {
            element.attribute(name, value);
        }
    }

    private static String extractOptions(Class<?> type, OptionSource optionSource) {
        if (type.isEnum()) {
            return OptionProviderHandler.extractOptionsForEnum(type, optionSource);
        }
        return OptionProviderHandler.extractOptionsForConstantsClass(type, optionSource);
    }

    private static String extractOptionsForEnum(Class<? extends Enum<?>> type, OptionSource optionSource) {
        String textMember = (String)StringUtils.defaultIfBlank((CharSequence)optionSource.textMember(), (CharSequence)"name");
        ArrayNode arrayNode = OBJECT_MAPPER.createArrayNode();
        for (Enum<?> enumConstant : type.getEnumConstants()) {
            Object text = OptionProviderHandler.invokeMethodOrInstanceField(enumConstant, textMember);
            if (text == null) continue;
            String value = StringUtils.isNotBlank((CharSequence)optionSource.valueMember()) && !"toString".equals(optionSource.valueMember()) ? OptionProviderHandler.invokeMethodOrInstanceField(enumConstant, optionSource.valueMember()) : enumConstant.toString();
            ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
            objectNode.put((String)StringUtils.defaultIfEmpty((CharSequence)optionSource.textMember(), (CharSequence)"jcr:title"), text.toString()).put((String)StringUtils.defaultIfEmpty((CharSequence)optionSource.valueMember(), (CharSequence)"value"), value != null ? value.toString() : "");
            for (String attributeMember : optionSource.attributeMembers()) {
                Object attributeValue = OptionProviderHandler.invokeMethodOrInstanceField(enumConstant, attributeMember);
                if (attributeValue == null) continue;
                objectNode.put(attributeMember, attributeValue.toString());
            }
            arrayNode.add((JsonNode)objectNode);
        }
        return StringUtil.escapeArray(arrayNode.toString());
    }

    private static String extractOptionsForConstantsClass(Class<?> type, OptionSource optionSource) {
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        for (Field field : type.getDeclaredFields()) {
            boolean isPublicStatic;
            boolean bl = isPublicStatic = Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers());
            if (!isPublicStatic) continue;
            try {
                Object value = field.get(type);
                fieldValues.put(field.getName(), value != null ? value.toString() : "");
            }
            catch (IllegalAccessException e) {
                PluginRuntime.context().getExceptionHandler().handle((Exception)new ExtensionApiException(type, e));
            }
        }
        if (!PatternUtil.isPattern((String)optionSource.textMember()) || !PatternUtil.isPattern((String)optionSource.valueMember())) {
            return OptionProviderHandler.getPlainOptionsForConstantsClass(fieldValues, optionSource);
        }
        return OptionProviderHandler.getMergedOptionsForConstantsClass(fieldValues, optionSource);
    }

    private static String getPlainOptionsForConstantsClass(Map<String, String> fieldValues, OptionSource optionSource) {
        ArrayNode arrayNode = OBJECT_MAPPER.createArrayNode();
        fieldValues.entrySet().stream().map(entry -> OBJECT_MAPPER.createObjectNode().put((String)StringUtils.defaultIfEmpty((CharSequence)optionSource.textMember(), (CharSequence)"jcr:title"), (String)entry.getKey()).put((String)StringUtils.defaultIfEmpty((CharSequence)optionSource.valueMember(), (CharSequence)"value"), (String)entry.getValue())).forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
        return StringUtil.escapeArray(arrayNode.toString());
    }

    private static String getMergedOptionsForConstantsClass(Map<String, String> fieldValues, OptionSource optionSource) {
        Map textValues = fieldValues.entrySet().stream().filter(entry -> PatternUtil.isMatch((String)((String)entry.getKey()), (String)optionSource.textMember())).collect(Collectors.toMap(entry -> PatternUtil.strip((String)((String)entry.getKey()), (String)optionSource.textMember()), entry -> Pair.of(entry.getKey(), entry.getValue()), (first, second) -> second, LinkedHashMap::new));
        fieldValues.entrySet().stream().filter(entry -> PatternUtil.isMatch((String)((String)entry.getKey()), (String)optionSource.valueMember())).forEach(entry -> {
            String valueName = PatternUtil.strip((String)((String)entry.getKey()), (String)optionSource.valueMember());
            if (textValues.containsKey(valueName)) {
                textValues.put(valueName, Pair.of((Object)((Pair)textValues.get(valueName)).getRight(), entry.getValue()));
            } else {
                textValues.put(valueName, Pair.of(entry.getKey(), entry.getValue()));
            }
        });
        ArrayNode arrayNode = OBJECT_MAPPER.createArrayNode();
        textValues.values().stream().map(pair -> OBJECT_MAPPER.createObjectNode().put(optionSource.textMember(), (String)pair.getKey()).put(optionSource.valueMember(), (String)pair.getValue())).forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
        return StringUtil.escapeArray(arrayNode.toString());
    }

    private static Object invokeMethodOrInstanceField(Object value, String name) {
        Object result = OptionProviderHandler.invokeMethod(value, name);
        if (result != null) {
            return result;
        }
        return OptionProviderHandler.invokeInstanceField(value, name);
    }

    private static Object invokeMethod(Object value, String name) {
        try {
            return value.getClass().getMethod(name, new Class[0]).invoke(value, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ExtensionApiException(value.getClass(), e));
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Object invokeInstanceField(Object value, String name) {
        if (value == null || StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        Field targetField = Arrays.stream(value.getClass().getDeclaredFields()).filter(field -> Modifier.isPublic(field.getModifiers()) && !Modifier.isStatic(field.getModifiers())).filter(field -> StringUtils.equals((CharSequence)field.getName(), (CharSequence)name)).findFirst().orElse(null);
        if (targetField == null) {
            return null;
        }
        try {
            return targetField.get(value);
        }
        catch (IllegalAccessException e) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ExtensionApiException(value.getClass(), e));
            return null;
        }
    }
}

