/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.widgets.common;

import com.exadel.aem.toolkit.api.annotations.widgets.DialogField;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.utils.NamingUtil;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;

public class DialogFieldAnnotationHandler
implements BiConsumer<Source, Target> {
    @Override
    public void accept(Source source, Target target) {
        DialogField dialogField = (DialogField)source.adaptTo(DialogField.class);
        if (dialogField == null) {
            return;
        }
        String name = (String)StringUtils.defaultIfEmpty((CharSequence)DialogFieldAnnotationHandler.getNameByDialogFieldProperty(dialogField), (CharSequence)NamingUtil.stripGetterPrefix(source));
        String slingSuffix = DialogFieldAnnotationHandler.getSlingSuffixByDialogFieldProperty(dialogField);
        String prefix = target.getNamePrefix();
        if (DialogFieldAnnotationHandler.isCompositeMultifieldField(target)) {
            Target multifieldAncestor = DialogFieldAnnotationHandler.getClosestMultifield(target);
            assert (multifieldAncestor != null);
            String ancestorPrefix = multifieldAncestor.getNamePrefix();
            prefix = StringUtils.removeStart((String)prefix, (String)ancestorPrefix);
        }
        if (!DialogFieldAnnotationHandler.isDeepMultifieldDescendant(target)) {
            prefix = DialogFieldAnnotationHandler.mergeWithPrefix("./", prefix);
        }
        name = DialogFieldAnnotationHandler.mergeWithPrefix(prefix, name) + target.getNamePostfix() + slingSuffix;
        target.attribute("name", name);
    }

    private static String getNameByDialogFieldProperty(DialogField dialogField) {
        if (StringUtils.isBlank((CharSequence)dialogField.name())) {
            return "";
        }
        if ("/".equals(dialogField.name()) || "./".equals(dialogField.name())) {
            return "./";
        }
        if (dialogField.name().contains("@")) {
            return NamingUtil.getValidFieldName(StringUtils.substringBeforeLast((String)dialogField.name(), (String)"@"));
        }
        return NamingUtil.getValidFieldName(dialogField.name());
    }

    private static String getSlingSuffixByDialogFieldProperty(DialogField dialogField) {
        if (!StringUtils.contains((CharSequence)dialogField.name(), (CharSequence)"@")) {
            return "";
        }
        String result = NamingUtil.getValidPlainName(StringUtils.substringAfterLast((String)dialogField.name(), (String)"@"));
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            return "@" + result;
        }
        return result;
    }

    private static String mergeWithPrefix(String left, String right) {
        if (StringUtils.isBlank((CharSequence)left)) {
            return right;
        }
        if ("./".equals(left) && "./".equals(right) || "./".equals(left) && right.startsWith("../")) {
            return right;
        }
        return left + right;
    }

    private static boolean isCompositeMultifieldField(Target target) {
        Target multifieldAncestor = DialogFieldAnnotationHandler.getClosestMultifield(target);
        if (multifieldAncestor == null) {
            return false;
        }
        return multifieldAncestor.getAttribute("composite", "").equals("{Boolean}true");
    }

    private static boolean isDeepMultifieldDescendant(Target target) {
        Target multifieldAncestor = DialogFieldAnnotationHandler.getClosestMultifield(target);
        if (multifieldAncestor == null) {
            return false;
        }
        return !multifieldAncestor.equals(target.getParent());
    }

    private static Target getClosestMultifield(Target target) {
        return target.findParent(t -> "granite/ui/components/coral/foundation/form/multifield".equals(t.getAttribute("sling:resourceType")));
    }
}

