/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.widgets.common;

import com.exadel.aem.toolkit.api.annotations.meta.ResourceType;
import com.exadel.aem.toolkit.api.annotations.widgets.Extends;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import com.exadel.aem.toolkit.plugin.sources.Sources;
import java.lang.annotation.Annotation;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import org.apache.maven.shared.utils.StringUtils;

public class InheritanceHandler
implements BiConsumer<Source, Target> {
    private final BiConsumer<Source, Target> descendantChain;

    public InheritanceHandler(BiConsumer<Source, Target> descendantChain) {
        this.descendantChain = descendantChain;
    }

    @Override
    public void accept(Source source, Target target) {
        if (this.descendantChain == null) {
            return;
        }
        Deque<Source> inheritanceTree = InheritanceHandler.getInheritanceTree(source);
        while (!inheritanceTree.isEmpty()) {
            this.descendantChain.accept(inheritanceTree.pollLast(), target);
        }
    }

    private static Deque<Source> getInheritanceTree(Source source) {
        LinkedList<Source> result = new LinkedList<Source>();
        Annotation widgetAnnotation = InheritanceHandler.getReferencedWidgetAnnotation(source);
        if (widgetAnnotation == null) {
            return result;
        }
        Extends extendsAnnotation = (Extends)source.adaptTo(Extends.class);
        while (extendsAnnotation != null) {
            String referencedFieldName = extendsAnnotation.field().isEmpty() ? source.getName() : extendsAnnotation.field();
            try {
                Source referencedField = Sources.fromMember(extendsAnnotation.value().getDeclaredField(referencedFieldName), extendsAnnotation.value());
                if (referencedField.equals(source) || result.contains(referencedField)) break;
                Annotation referencedFieldWidgetAnnotation = InheritanceHandler.getReferencedWidgetAnnotation(referencedField);
                if (referencedFieldWidgetAnnotation != null && widgetAnnotation.annotationType().equals(referencedFieldWidgetAnnotation.annotationType())) {
                    result.add(referencedField);
                }
                extendsAnnotation = (Extends)referencedField.adaptTo(Extends.class);
            }
            catch (NoSuchFieldException e) {
                PluginRuntime.context().getExceptionHandler().handle((Exception)e);
                extendsAnnotation = null;
            }
        }
        return result;
    }

    private static Annotation getReferencedWidgetAnnotation(Source source) {
        for (Annotation annotation : (Annotation[])source.adaptTo(Annotation[].class)) {
            Metadata metadata = Metadata.from(annotation);
            ResourceType resourceType = metadata.getAnnotation(ResourceType.class);
            if (resourceType == null || !StringUtils.isNotBlank((String)resourceType.value())) continue;
            return annotation;
        }
        return null;
    }
}

