/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.widgets.common;

import com.exadel.aem.toolkit.api.annotations.meta.PropertyRendering;
import com.exadel.aem.toolkit.api.annotations.meta.ResourceTypes;
import com.exadel.aem.toolkit.api.annotations.widgets.DialogField;
import com.exadel.aem.toolkit.api.annotations.widgets.MultiField;
import com.exadel.aem.toolkit.api.annotations.widgets.accessory.Multiple;
import com.exadel.aem.toolkit.api.annotations.widgets.property.Property;
import com.exadel.aem.toolkit.api.handlers.Handler;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.handlers.common.CasualAnnotationsHandler;
import com.exadel.aem.toolkit.plugin.handlers.placement.containers.MultiFieldHandler;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.targets.Targets;
import com.exadel.aem.toolkit.plugin.utils.ClassUtil;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class MultipleAnnotationHandler
implements BiConsumer<Source, Target> {
    private static final String POSTFIX_NESTED = "_nested";

    @Override
    public void accept(Source source, Target target) {
        if (source.adaptTo(Multiple.class) == null) {
            return;
        }
        boolean isComposite = false;
        if (this.isFieldSet(target)) {
            this.wrapFieldSet(target);
            isComposite = true;
        } else if (this.isMultifield(target)) {
            this.wrapNestedMultifield(source, target);
            isComposite = true;
        } else {
            this.wrapSingularField(source, target);
        }
        if (isComposite) {
            target.getOrCreateTarget("field").attribute("sling:resourceType", "granite/ui/components/coral/foundation/container");
            target.attribute("composite", true);
        }
        target.getAttributes().remove("name");
        target.attribute("sling:resourceType", "granite/ui/components/coral/foundation/form/multifield");
        List<Handler> multifieldHandlers = PluginRuntime.context().getReflection().getHandlers(target.getScope(), MultiField.class).stream().filter(handler -> !handler.getClass().equals(MultiFieldHandler.class)).collect(Collectors.toList());
        new CasualAnnotationsHandler(multifieldHandlers).accept(source, target);
    }

    private boolean isFieldSet(Target target) {
        return StringUtils.equals((CharSequence)target.getAttribute("sling:resourceType"), (CharSequence)"granite/ui/components/coral/foundation/form/fieldset");
    }

    private boolean isMultifield(Target target) {
        boolean hasSingularFieldNode;
        if (StringUtils.equals((CharSequence)target.getAttribute("sling:resourceType"), (CharSequence)"granite/ui/components/coral/foundation/form/multifield")) {
            return true;
        }
        boolean bl = hasSingularFieldNode = target.getChildren().size() == 1 && "field".equals(((Target)target.getChildren().get(0)).getName());
        if (!hasSingularFieldNode) {
            return false;
        }
        return ClassUtil.getConstantValues(ResourceTypes.class).values().stream().map(Object::toString).noneMatch(restype -> restype.equals(target.getAttribute("sling:resourceType")));
    }

    private void wrapSingularField(Source source, Target target) {
        Target fieldSubresource = target.createTarget("field");
        Map<String, PropertyTransferPolicy> transferPolicies = MultipleAnnotationHandler.getTransferPolicies(source);
        transferPolicies.put(fieldSubresource.getPath(), PropertyTransferPolicy.LEAVE_IN_MULTIFIELD);
        MultipleAnnotationHandler.transferProperties(target, fieldSubresource, transferPolicies);
    }

    private void wrapFieldSet(Target target) {
        Target fieldSubresource = target.createTarget("field");
        Target itemsSubresource = target.getTarget("items");
        itemsSubresource.getChildren().forEach(child -> {
            String modifiedName = StringUtils.removeStart((String)((String)child.getAttributes().get("name")), (String)"./");
            child.attribute("name", modifiedName);
        });
        fieldSubresource.getChildren().add(itemsSubresource);
        target.getChildren().remove(itemsSubresource);
        MultipleAnnotationHandler.transferProperties(target, fieldSubresource, (Map<String, PropertyTransferPolicy>)ImmutableMap.of((Object)"@name", (Object)((Object)PropertyTransferPolicy.MOVE_TO_NESTED_NODE)));
    }

    private void wrapNestedMultifield(Source source, Target target) {
        Target fieldSubresource = Targets.newTarget("field", target);
        Target itemsSubresource = fieldSubresource.createTarget("items");
        Target nestedMultifield = itemsSubresource.createTarget(source.getName() + POSTFIX_NESTED);
        Map<String, PropertyTransferPolicy> standardPolicies = MultipleAnnotationHandler.getTransferPolicies(source);
        LinkedHashMap<String, PropertyTransferPolicy> multifieldPolicies = new LinkedHashMap<String, PropertyTransferPolicy>();
        multifieldPolicies.put("@composite", PropertyTransferPolicy.COPY_TO_NESTED_NODE);
        multifieldPolicies.put("./field", PropertyTransferPolicy.MOVE_TO_NESTED_NODE);
        multifieldPolicies.putAll(standardPolicies);
        multifieldPolicies.put("@sling:resourceType", PropertyTransferPolicy.COPY_TO_NESTED_NODE);
        MultipleAnnotationHandler.transferProperties(target, nestedMultifield, multifieldPolicies);
        Target nestedMultifieldFieldSubresource = nestedMultifield.getTarget("field");
        String nestedMultifieldFieldName = StringUtils.defaultString((String)((String)nestedMultifieldFieldSubresource.getAttributes().get("name")));
        fieldSubresource.attribute("name", nestedMultifieldFieldName);
        nestedMultifieldFieldSubresource.getAttributes().put("name", nestedMultifieldFieldName + POSTFIX_NESTED);
        target.getChildren().add(fieldSubresource);
    }

    private static Map<String, PropertyTransferPolicy> getTransferPolicies(Source source) {
        LinkedHashMap<String, PropertyTransferPolicy> transferPolicies = new LinkedHashMap<String, PropertyTransferPolicy>();
        Arrays.stream(DialogField.class.getDeclaredMethods()).forEach(method -> {
            String propertyName = method.getAnnotation(PropertyRendering.class) != null ? (String)StringUtils.defaultIfEmpty((CharSequence)method.getAnnotation(PropertyRendering.class).name(), (CharSequence)method.getName()) : method.getName();
            transferPolicies.put("@" + propertyName, PropertyTransferPolicy.LEAVE_IN_MULTIFIELD);
        });
        Arrays.stream((Object[])source.adaptTo(Property[].class)).forEach(property -> transferPolicies.put("@" + property.name(), PropertyTransferPolicy.LEAVE_IN_MULTIFIELD));
        transferPolicies.put("@name", PropertyTransferPolicy.MOVE_TO_NESTED_NODE);
        transferPolicies.put("@required", PropertyTransferPolicy.MOVE_TO_NESTED_NODE);
        transferPolicies.put("@wrapperClass", PropertyTransferPolicy.MOVE_TO_NESTED_NODE);
        transferPolicies.put("@jcr:primaryType", PropertyTransferPolicy.COPY_TO_NESTED_NODE);
        transferPolicies.put("@disabled", PropertyTransferPolicy.COPY_TO_NESTED_NODE);
        transferPolicies.put("@renderHidden", PropertyTransferPolicy.COPY_TO_NESTED_NODE);
        transferPolicies.put("@*", PropertyTransferPolicy.MOVE_TO_NESTED_NODE);
        transferPolicies.put("./granite:data", PropertyTransferPolicy.LEAVE_IN_MULTIFIELD);
        transferPolicies.put("./*", PropertyTransferPolicy.MOVE_TO_NESTED_NODE);
        return transferPolicies;
    }

    private static void transferProperties(Target from, Target to, Map<String, PropertyTransferPolicy> policies) {
        ArrayList<String> removableAttributes = new ArrayList<String>();
        for (String attribute2 : from.getAttributes().keySet()) {
            PropertyTransferPolicy policy = MultipleAnnotationHandler.getPolicyForAttribute(policies, attribute2);
            if (policy != PropertyTransferPolicy.LEAVE_IN_MULTIFIELD) {
                to.attribute(attribute2, (String)from.getAttributes().get(attribute2));
            }
            if (policy != PropertyTransferPolicy.MOVE_TO_NESTED_NODE) continue;
            removableAttributes.add(attribute2);
        }
        removableAttributes.forEach(attribute -> {
            String cfr_ignored_0 = (String)from.getAttributes().remove(attribute);
        });
        ArrayList<Target> removableChildren = new ArrayList<Target>();
        for (Target child2 : from.getChildren()) {
            PropertyTransferPolicy policy = MultipleAnnotationHandler.getPolicyForChildNode(policies, child2);
            if (policy == PropertyTransferPolicy.LEAVE_IN_MULTIFIELD) continue;
            to.getChildren().add(child2);
            if (policy != PropertyTransferPolicy.MOVE_TO_NESTED_NODE) continue;
            removableChildren.add(child2);
        }
        removableChildren.forEach(child -> from.getChildren().remove(child));
    }

    private static PropertyTransferPolicy getPolicyForAttribute(Map<String, PropertyTransferPolicy> policies, String name) {
        return policies.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("@")).filter(entry -> MultipleAnnotationHandler.isAttributePolicyMatch(name, entry)).map(Map.Entry::getValue).findFirst().orElse(PropertyTransferPolicy.LEAVE_IN_MULTIFIELD);
    }

    private static boolean isAttributePolicyMatch(String name, Map.Entry<String, PropertyTransferPolicy> policyEntry) {
        String key = StringUtils.stripStart((String)policyEntry.getKey(), (String)"@");
        return key.endsWith("*") ? name.startsWith(StringUtils.stripEnd((String)key, (String)"*")) : name.equals(key);
    }

    private static PropertyTransferPolicy getPolicyForChildNode(Map<String, PropertyTransferPolicy> policies, Target child) {
        return Stream.concat(policies.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("/")), policies.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("./"))).filter(entry -> MultipleAnnotationHandler.isChildNodePolicyMatch(child, entry)).map(Map.Entry::getValue).findFirst().orElse(PropertyTransferPolicy.LEAVE_IN_MULTIFIELD);
    }

    private static boolean isChildNodePolicyMatch(Target child, Map.Entry<String, PropertyTransferPolicy> policyEntry) {
        boolean isAbsolutePath = policyEntry.getKey().startsWith("/");
        String key = isAbsolutePath ? policyEntry.getKey() : StringUtils.substring((String)policyEntry.getKey(), (int)"./".length());
        String checkedValue = isAbsolutePath ? child.getPath() : child.getName();
        return key.endsWith("*") ? StringUtils.startsWith((CharSequence)checkedValue, (CharSequence)StringUtils.stripEnd((String)key, (String)"*")) : StringUtils.equals((CharSequence)checkedValue, (CharSequence)key);
    }

    private static enum PropertyTransferPolicy {
        LEAVE_IN_MULTIFIELD,
        COPY_TO_NESTED_NODE,
        MOVE_TO_NESTED_NODE;

    }
}

