/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.widgets.common;

import com.exadel.aem.toolkit.api.annotations.widgets.property.Property;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.utils.NamingUtil;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;

public class PropertyAnnotationHandler
implements BiConsumer<Source, Target> {
    @Override
    public void accept(Source source, Target target) {
        Arrays.stream((Object[])source.adaptTo(Property[].class)).forEach(p -> this.acceptProperty((Property)p, target));
    }

    private void acceptProperty(Property property, Target target) {
        String propertyPath;
        String propertyName;
        if (property.name().contains("/")) {
            propertyName = StringUtils.substringAfterLast((String)property.name(), (String)"/");
            propertyPath = StringUtils.substringBeforeLast((String)property.name(), (String)"/");
        } else {
            propertyName = property.name();
            propertyPath = null;
        }
        Target effectiveTarget = StringUtils.isNotBlank(propertyPath) ? target.getOrCreateTarget(propertyPath) : target;
        effectiveTarget.attribute(NamingUtil.getValidFieldName(propertyName), property.value());
    }
}

