/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.widgets.rte;

import com.exadel.aem.toolkit.api.annotations.widgets.rte.Characters;
import com.exadel.aem.toolkit.api.annotations.widgets.rte.HtmlLinkRules;
import com.exadel.aem.toolkit.api.annotations.widgets.rte.HtmlPasteRules;
import com.exadel.aem.toolkit.api.annotations.widgets.rte.RichTextEditor;
import com.exadel.aem.toolkit.api.handlers.Handler;
import com.exadel.aem.toolkit.api.handlers.Handles;
import com.exadel.aem.toolkit.api.handlers.Source;
import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.exceptions.ValidationException;
import com.exadel.aem.toolkit.plugin.handlers.widgets.rte.RteNodeWithListBuilder;
import com.exadel.aem.toolkit.plugin.handlers.widgets.rte.RteTreeWithListsBuilder;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import com.exadel.aem.toolkit.plugin.metadata.Property;
import com.exadel.aem.toolkit.plugin.metadata.RenderingFilter;
import com.exadel.aem.toolkit.plugin.utils.StringUtil;
import com.exadel.aem.toolkit.plugin.validators.CharactersObjectValidator;
import com.exadel.aem.toolkit.plugin.validators.Validation;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

@Handles(value={RichTextEditor.class})
public class RichTextEditorHandler
implements Handler {
    static final String PLUGIN_FEATURE_SEPARATOR = "#";
    private static final String KEYWORD_AUTO = "auto";
    private static final String FEATURE_ALL = "*";
    private static final String FEATURE_TOKEN = "(?:[\\w-]+#[\\w-:]+|-)";
    private static final Pattern FEATURE_TOKEN_PATTERN = Pattern.compile(String.format("^%s$", "(?:[\\w-]+#[\\w-:]+|-)"));
    private static final Pattern FEATURE_TOKEN_ARRAY_PATTERN = Pattern.compile(String.format("^\\[\\s*%s(?:\\s*,\\s*%1$s)*\\s*]$", "(?:[\\w-]+#[\\w-:]+|-)"));
    private static final Pattern HTML_PASTE_RULES_ALLOW_PATTERN = Pattern.compile("^allow([A-Z].+?)s?$");
    private static final String MALFORMED_TOKEN_EXCEPTION_MESSAGE = "Malformed feature token in @RichTextEditor";
    private RichTextEditor rteAnnotation;
    private final boolean renderDialogFullScreenNode;

    public RichTextEditorHandler() {
        this(true);
    }

    public RichTextEditorHandler(boolean renderDialogFullScreenNode) {
        this.renderDialogFullScreenNode = renderDialogFullScreenNode;
    }

    public void accept(Source source, Target target) {
        this.accept((RichTextEditor)source.adaptTo(RichTextEditor.class), target);
    }

    public void accept(RichTextEditor annotation, Target target) {
        this.rteAnnotation = annotation;
        RteNodeWithListBuilder inlineBuilder = new RteNodeWithListBuilder("inline", "toolbar");
        RteNodeWithListBuilder fullScreenBuilder = new RteNodeWithListBuilder("fullscreen", "toolbar");
        RteTreeWithListsBuilder popoversBuilder = new RteTreeWithListsBuilder("popovers", "items", true);
        popoversBuilder.setPostprocessing(popoverNode -> popoverNode.attribute("ref", popoverNode.getName()));
        inlineBuilder.setChildBuilder(popoversBuilder);
        fullScreenBuilder.setChildBuilder(new RteTreeWithListsBuilder(popoversBuilder));
        RteNodeWithListBuilder tableEditBuilder = new RteNodeWithListBuilder("tableEditOptions", "toolbar");
        tableEditBuilder.setFilter((pluginId, feature) -> "table".equals(pluginId) && !"table#table".equals(feature));
        RteTreeWithListsBuilder pluginsBuilder = new RteTreeWithListsBuilder("rtePlugins", "features");
        pluginsBuilder.setFilter((pluginId, feature) -> !"table".equals(pluginId) || FEATURE_ALL.equals(feature));
        Stream.concat(Arrays.stream(annotation.features()).map(feature -> new ImmutablePair((Object)inlineBuilder, feature)), Arrays.stream(annotation.fullscreenFeatures()).map(feature -> new ImmutablePair((Object)fullScreenBuilder, feature))).forEach(featureItem -> RichTextEditorHandler.processFeatureItem((ImmutablePair<RteNodeWithListBuilder, String>)featureItem, tableEditBuilder, pluginsBuilder));
        Target uiSettings = target.getOrCreateTarget("uiSettings");
        Target cui = uiSettings.getOrCreateTarget("cui");
        inlineBuilder.build(cui);
        if (fullScreenBuilder.isEmpty() && !inlineBuilder.isEmpty()) {
            inlineBuilder.setName("fullscreen");
            inlineBuilder.build(cui);
            if (this.renderDialogFullScreenNode) {
                inlineBuilder.setName("dialogFullScreen");
                inlineBuilder.build(cui);
            }
        }
        fullScreenBuilder.build(cui);
        fullScreenBuilder.setName("dialogFullScreen");
        if (this.renderDialogFullScreenNode) {
            fullScreenBuilder.build(cui);
        }
        tableEditBuilder.build(cui);
        this.getIconsNode(cui);
        if (annotation.externalStyleSheets().length != 0) {
            target.attribute("externalStyleSheets", Arrays.asList(annotation.externalStyleSheets()).toString().replace(" ", ""));
        }
        Target rtePlugins = pluginsBuilder.build(target);
        this.getFormatNode(rtePlugins.getOrCreateTarget("paraformat"));
        this.getSpecialCharactersNode(rtePlugins.getOrCreateTarget("misctools"));
        this.populatePasteRulesNode(rtePlugins);
        this.populateStylesNode(rtePlugins.getOrCreateTarget("styles").attribute("jcr:primaryType", "cq:WidgetCollection"));
        if (rtePlugins.exists("undo")) {
            rtePlugins.getTarget("undo").attributes((Annotation)annotation, member -> "maxUndoSteps".equals(member.getName()));
        }
        rtePlugins.getOrCreateTarget("keys").attributes((Annotation)annotation, member -> "tabSize".equals(member.getName()));
        if (rtePlugins.exists("lists")) {
            rtePlugins.getTarget("lists").attributes((Annotation)annotation, member -> "indentSize".equals(member.getName()));
        }
        this.populateHtmlLinkRules(target);
        RichTextEditorHandler.clearEmpty(target);
        if (!RichTextEditorHandler.isEmpty(rtePlugins)) {
            rtePlugins.getOrCreateTarget("styles");
        }
    }

    private static void processFeatureItem(ImmutablePair<RteNodeWithListBuilder, String> featureItem, RteNodeWithListBuilder tableEditBuilder, RteTreeWithListsBuilder pluginsBuilder) {
        RteNodeWithListBuilder nodeBuilder = (RteNodeWithListBuilder)featureItem.left;
        String feature = (String)featureItem.right;
        if (StringUtils.isBlank((CharSequence)feature)) {
            return;
        }
        if (FEATURE_TOKEN_PATTERN.matcher(feature).matches()) {
            nodeBuilder.store(null, feature);
            pluginsBuilder.store(null, feature);
        } else if (FEATURE_TOKEN_ARRAY_PATTERN.matcher(feature).matches()) {
            String[] nestedTokens = RichTextEditorHandler.getNestedTokens(feature);
            String leadingPluginToken = StringUtils.substringBefore((String)nestedTokens[0], (String)PLUGIN_FEATURE_SEPARATOR);
            if (leadingPluginToken.equals("table")) {
                nodeBuilder.store(null, "table#table");
                tableEditBuilder.storeMany(leadingPluginToken, nestedTokens);
            } else {
                nodeBuilder.store(null, PLUGIN_FEATURE_SEPARATOR + leadingPluginToken);
                nodeBuilder.getChildBuilder().storeMany(leadingPluginToken, nestedTokens);
            }
            if (leadingPluginToken.equals("table") || leadingPluginToken.equals("paraformat") || leadingPluginToken.equals("styles")) {
                pluginsBuilder.store(leadingPluginToken, FEATURE_ALL);
            } else {
                pluginsBuilder.storeMany(null, nestedTokens);
            }
        } else {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ValidationException(MALFORMED_TOKEN_EXCEPTION_MESSAGE, new Object[0]));
        }
    }

    private void getIconsNode(Target parent) {
        Target icons = parent.getOrCreateTarget("icons");
        Arrays.stream(this.rteAnnotation.icons()).forEach(iconMapping -> icons.getOrCreateTarget(iconMapping.command()).attributes((Annotation)iconMapping, (Predicate)new RenderingFilter((Annotation)iconMapping)));
    }

    private void getFormatNode(Target parent) {
        Target formats = parent.getOrCreateTarget("formats").attribute("jcr:primaryType", "cq:WidgetCollection");
        Arrays.stream(this.rteAnnotation.formats()).forEach(paragraphFormat -> Validation.forType(paragraphFormat.annotationType()).test(paragraphFormat));
        Arrays.stream(this.rteAnnotation.formats()).forEach(paragraphFormat -> formats.getOrCreateTarget(paragraphFormat.tag()).attributes((Annotation)paragraphFormat, (Predicate)new RenderingFilter((Annotation)paragraphFormat)));
    }

    private void getSpecialCharactersNode(Target parent) {
        Target charsConfigNode = parent.getOrCreateTarget("specialCharsConfig").getOrCreateTarget("chars");
        CharactersObjectValidator validator = new CharactersObjectValidator();
        Annotation[] validCharactersAnnotations = (Annotation[])Arrays.stream(this.rteAnnotation.specialCharacters()).map(source -> {
            validator.filter((Characters)source);
            return source;
        }).toArray(Annotation[]::new);
        Arrays.stream(validCharactersAnnotations).forEach(annotation -> Validation.forType(annotation.annotationType()).test(annotation));
        Arrays.stream(validCharactersAnnotations).forEach(annotation -> charsConfigNode.getOrCreateTarget(RichTextEditorHandler.getCharactersTagName((Characters)annotation)).attributes(annotation, (Predicate)new RenderingFilter((Annotation)annotation)));
    }

    private void populateStylesNode(Target parent) {
        Target styles = parent.getOrCreateTarget("styles").attribute("jcr:primaryType", "cq:WidgetCollection");
        if (!this.featureExists("[styles#styles:getStyles:styles-pulldown]")) {
            return;
        }
        Arrays.stream(this.rteAnnotation.styles()).forEach(style -> styles.getOrCreateTarget(style.cssName()).attributes((Annotation)style, (Predicate)new RenderingFilter((Annotation)style)));
    }

    private void populatePasteRulesNode(Target parent) {
        HtmlPasteRules rules = (HtmlPasteRules)Metadata.from(this.rteAnnotation.htmlPasteRules());
        Target edit = parent.getOrCreateTarget("edit");
        Target htmlPasteRulesNode = edit.getOrCreateTarget("htmlPasteRules");
        List<String> nonDefaultAllowPropsNames = ((Metadata)rules).stream(false, false).filter(prop -> !prop.valueIsDefault()).map(Property::getName).filter(name -> HTML_PASTE_RULES_ALLOW_PATTERN.matcher((CharSequence)name).matches()).map(name -> HTML_PASTE_RULES_ALLOW_PATTERN.matcher((CharSequence)name).replaceAll("$1").toLowerCase()).filter(propName -> {
            if (StringUtils.equalsAny((CharSequence)propName, (CharSequence[])new CharSequence[]{"table", "list"})) {
                htmlPasteRulesNode.getOrCreateTarget(propName).attribute("allow", false).attribute("ignoreMode", "table".equals(propName) ? rules.allowTables().toString() : rules.allowLists().toString());
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        if (!nonDefaultAllowPropsNames.isEmpty()) {
            Target allowBasicsNode = htmlPasteRulesNode.getOrCreateTarget("allowBasics");
            nonDefaultAllowPropsNames.forEach(fieldName -> allowBasicsNode.attribute(fieldName, false));
        }
        String blockTags = rules.allowedBlockTags().length == 0 ? null : Arrays.asList(rules.allowedBlockTags()).toString().replace(" ", "");
        htmlPasteRulesNode.attribute("allowBlockTags", blockTags).attribute("fallbackBlockTag", rules.fallbackBlockTag().isEmpty() ? null : rules.fallbackBlockTag());
        if (!RichTextEditorHandler.isEmpty(htmlPasteRulesNode)) {
            edit.attribute("defaultPasteMode", this.rteAnnotation.defaultPasteMode().toString().toLowerCase());
        }
    }

    private void populateHtmlLinkRules(Target parent) {
        HtmlLinkRules rulesAnnotation = this.rteAnnotation.htmlLinkRules();
        boolean hasAllDefaultValues = Metadata.from(rulesAnnotation).stream().allMatch(Property::valueIsDefault);
        if (hasAllDefaultValues) {
            return;
        }
        parent.getOrCreateTarget("htmlRules").getOrCreateTarget("links").attribute("cssExternal", rulesAnnotation.cssExternal().isEmpty() ? null : rulesAnnotation.cssExternal()).attribute("cssInternal", rulesAnnotation.cssInternal().isEmpty() ? null : rulesAnnotation.cssInternal()).attribute("defaultProtocol", rulesAnnotation.defaultProtocol()).attribute("protocols", Arrays.asList(rulesAnnotation.protocols()).toString().replace(" ", "")).getOrCreateTarget("targetConfig").attribute("mode", KEYWORD_AUTO).attribute("targetExternal", rulesAnnotation.targetExternal().toString()).attribute("targetInternal", rulesAnnotation.targetInternal().toString());
    }

    private boolean featureExists(String value) {
        return Stream.concat(Arrays.stream(this.rteAnnotation.features()), Arrays.stream(this.rteAnnotation.fullscreenFeatures())).flatMap(s -> StringUtil.parseCollection(s).stream()).anyMatch(s -> s.equals(value) || s.equals(StringUtil.parseCollection(value).get(0)));
    }

    private static String[] getNestedTokens(String array) {
        return StringUtil.parseCollection(array).toArray(new String[0]);
    }

    private static boolean isEmpty(Target target) {
        return target.getAttributes().size() == 1 && target.getAttributes().containsKey("jcr:primaryType") && target.getChildren().isEmpty();
    }

    private static void clearEmpty(Target target) {
        target.getChildren().forEach(RichTextEditorHandler::clearEmpty);
        target.getChildren().removeIf(RichTextEditorHandler::isEmpty);
    }

    private static String getCharactersTagName(Characters characters) {
        String result = characters.rangeStart() > 0L ? String.valueOf(characters.rangeStart()) : characters.entity();
        return "\"" + result + "\"";
    }
}

