/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.handlers.widgets.rte;

import com.exadel.aem.toolkit.api.handlers.Target;
import com.exadel.aem.toolkit.plugin.handlers.widgets.rte.RteNodeBuilderBase;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class RteTreeWithListsBuilder
extends RteNodeBuilderBase {
    private final Map<String, Set<String>> argumentTree;
    private final boolean addPluginIdsToFeatures;

    RteTreeWithListsBuilder(String tagName, String attributeName) {
        this(tagName, attributeName, false);
    }

    RteTreeWithListsBuilder(String tagName, String attributeName, boolean addPluginIdsToFeatures) {
        super(tagName, attributeName);
        this.argumentTree = new HashMap<String, Set<String>>();
        this.addPluginIdsToFeatures = addPluginIdsToFeatures;
    }

    RteTreeWithListsBuilder(RteTreeWithListsBuilder sample) {
        super(sample.getName(), sample.getAttributeName());
        this.addPluginIdsToFeatures = sample.addPluginIdsToFeatures;
        this.setPostprocessing(sample.getPostprocessing());
        this.argumentTree = new HashMap<String, Set<String>>();
    }

    @Override
    public void store(String pluginId, String feature) {
        String mapValue;
        String mapKey = StringUtils.substringBefore((String)feature, (String)"#");
        String string = mapValue = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{pluginId, mapKey}) && !pluginId.equals(mapKey) ? feature : StringUtils.substringAfter((String)feature, (String)"#");
        if (!StringUtils.isEmpty((CharSequence)pluginId)) {
            mapKey = pluginId;
        }
        if (this.getFilter() != null && !this.getFilter().test(mapKey, mapValue)) {
            return;
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{mapKey, mapValue})) {
            this.argumentTree.computeIfAbsent(mapKey, k -> new LinkedHashSet()).add(mapValue);
        }
    }

    @Override
    boolean isEmpty() {
        return this.argumentTree.isEmpty();
    }

    @Override
    Target build(Target parent) {
        Target result = parent.getOrCreateTarget(this.getName());
        this.argumentTree.forEach((pluginId, features) -> this.createChildNode(result, (String)pluginId, (Set<String>)features));
        return result;
    }

    private void createChildNode(Target parent, String pluginId, Set<String> features) {
        Target node = parent.getOrCreateTarget(pluginId);
        List valueList = features.stream().map(value -> this.addPluginIdsToFeatures && !value.contains("#") && !value.contains(":") ? pluginId + "#" + value : value).collect(Collectors.toList());
        if (valueList.size() > 1) {
            node.attribute(this.getAttributeName(), valueList.toString().replace(" ", ""));
        } else {
            node.attribute(this.getAttributeName(), (String)valueList.get(0));
        }
        if (this.getPostprocessing() != null) {
            this.getPostprocessing().accept(node);
        }
    }
}

