/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.maven;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.cli.Commandline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JvmHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JvmHelper.class);
    private static final String PROPERTY_MAVEN_HOME = "maven.home";
    private static final String PROPERTY_CLASSWORLDS = "classworlds.conf";
    private static final String PROPERTY_CLASS_PATH = "java.class.path";
    private static final String ARGUMENT_FORMAT = "-D%s=%s";

    private JvmHelper() {
    }

    static boolean shouldRelaunch(ToolchainManager toolchainManager, MavenSession session) {
        String toolchainJavaHome;
        String javaHome = JvmHelper.getJavaHome();
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{javaHome, toolchainJavaHome = JvmHelper.getJavaHome(toolchainManager, session)}) || StringUtils.equals((CharSequence)javaHome, (CharSequence)toolchainJavaHome)) {
            return false;
        }
        return JvmHelper.validateProperties();
    }

    static String getJavaExecutable(ToolchainManager toolchainManager, MavenSession session) {
        Toolchain jdkToolchain = toolchainManager.getToolchainFromBuildContext("jdk", session);
        return jdkToolchain != null ? jdkToolchain.findTool("java") : "";
    }

    static String getJavaHome() {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{System.getProperty("JAVA_HOME"), System.getProperty("java.home")});
    }

    static String getJavaHome(String executable) {
        Path result = Paths.get(executable, new String[0]).getParent();
        if ("bin".equals(result.getFileName().toString())) {
            result = result.getParent();
        }
        return result.toAbsolutePath().toString();
    }

    private static String getJavaHome(ToolchainManager toolchainManager, MavenSession session) {
        String executable = JvmHelper.getJavaExecutable(toolchainManager, session);
        if (StringUtils.isEmpty((CharSequence)executable)) {
            return "";
        }
        return JvmHelper.getJavaHome(executable);
    }

    private static boolean validateProperties() {
        boolean result = true;
        for (String property : Arrays.asList(PROPERTY_CLASS_PATH, PROPERTY_CLASSWORLDS, PROPERTY_MAVEN_HOME)) {
            if (!StringUtils.isEmpty((CharSequence)System.getProperty(property))) continue;
            LOG.warn("Property {} is not defined", (Object)property);
            result = false;
        }
        return result;
    }

    static CommandLineBuilder commandLine() {
        return new CommandLineBuilder();
    }

    static class CommandLineBuilder {
        private String executable;
        private String directory;
        private String pluginCommand;
        private Map<String, String> arguments;

        CommandLineBuilder() {
        }

        CommandLineBuilder executable(String value) {
            this.executable = value;
            return this;
        }

        CommandLineBuilder directory(String value) {
            this.directory = value;
            return this;
        }

        CommandLineBuilder pluginCommand(String value) {
            this.pluginCommand = value;
            return this;
        }

        CommandLineBuilder argument(String key, String value) {
            if (this.arguments == null) {
                this.arguments = new HashMap<String, String>();
            }
            this.arguments.put(key, value);
            return this;
        }

        Commandline build() {
            Commandline commandline = new Commandline();
            commandline.setExecutable(this.executable);
            commandline.setWorkingDirectory(this.directory);
            ArrayList<String> commandLineArgs = new ArrayList<String>();
            commandLineArgs.add(String.format(JvmHelper.ARGUMENT_FORMAT, "maven.multiModuleProjectDirectory", this.directory));
            commandLineArgs.add(String.format(JvmHelper.ARGUMENT_FORMAT, JvmHelper.PROPERTY_MAVEN_HOME, System.getProperty(JvmHelper.PROPERTY_MAVEN_HOME)));
            commandLineArgs.add(String.format(JvmHelper.ARGUMENT_FORMAT, JvmHelper.PROPERTY_CLASSWORLDS, System.getProperty(JvmHelper.PROPERTY_CLASSWORLDS)));
            commandLineArgs.add("-classpath");
            commandLineArgs.add(System.getProperty(JvmHelper.PROPERTY_CLASS_PATH));
            commandLineArgs.add("org.codehaus.classworlds.Launcher");
            commandLineArgs.add(this.pluginCommand);
            if (this.arguments != null) {
                this.arguments.forEach((key, value) -> commandLineArgs.add(String.format(JvmHelper.ARGUMENT_FORMAT, key, value)));
            }
            commandLineArgs.add("--batch-mode");
            commandline.addArguments(commandLineArgs.toArray(new String[0]));
            return commandline;
        }
    }
}

