/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.maven;

import com.exadel.aem.toolkit.api.runtime.ExceptionHandler;
import com.exadel.aem.toolkit.plugin.exceptions.PluginException;
import com.exadel.aem.toolkit.plugin.exceptions.handlers.ExceptionHandlers;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntimeContext;
import com.exadel.aem.toolkit.plugin.maven.PluginSettings;
import com.exadel.aem.toolkit.plugin.runtime.ReflectionContextHelper;
import com.exadel.aem.toolkit.plugin.runtime.XmlContextHelper;
import com.exadel.aem.toolkit.plugin.utils.XmlFactory;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;

class LoadedRuntimeContext
implements PluginRuntimeContext {
    private static final String XML_EXCEPTION_MESSAGE = "Could not initialize XML runtime";
    private PluginSettings settings;
    private ReflectionContextHelper pluginReflections;
    private ExceptionHandler exceptionHandler;
    private XmlContextHelper xmlRuntime;

    LoadedRuntimeContext() {
    }

    @Override
    public PluginSettings getSettings() {
        return this.settings;
    }

    @Override
    public ReflectionContextHelper getReflection() {
        return this.pluginReflections;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public XmlContextHelper getXmlUtility() {
        return this.xmlRuntime;
    }

    @Override
    public XmlContextHelper newXmlUtility() {
        try {
            this.xmlRuntime = new XmlContextHelper(XmlFactory.newDocument());
        }
        catch (ParserConfigurationException e) {
            throw new PluginException(XML_EXCEPTION_MESSAGE, e);
        }
        return this.xmlRuntime;
    }

    public static class Builder {
        private List<String> classPathElements;
        private PluginSettings settings = new PluginSettings();
        private ExceptionHandler exceptionHandler;
        private final Consumer<LoadedRuntimeContext> onComplete;

        Builder(Consumer<LoadedRuntimeContext> onComplete) {
            this.onComplete = onComplete;
        }

        Builder classPathElements(List<String> value) {
            this.classPathElements = value;
            return this;
        }

        Builder settings(PluginSettings value) {
            this.settings = value;
            return this;
        }

        Builder exceptionHandler(ExceptionHandler value) {
            this.exceptionHandler = value;
            return this;
        }

        void build() {
            if (!this.isValid()) {
                return;
            }
            LoadedRuntimeContext result = new LoadedRuntimeContext();
            result.settings = this.settings;
            result.pluginReflections = ReflectionContextHelper.fromCodeScope(this.classPathElements);
            result.exceptionHandler = this.exceptionHandler != null ? this.exceptionHandler : ExceptionHandlers.forSetting(this.settings.getTerminateOnRule());
            result.newXmlUtility();
            this.onComplete.accept(result);
        }

        private boolean isValid() {
            return this.classPathElements != null && !this.classPathElements.isEmpty();
        }
    }
}

