/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.maven;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class PluginInfo {
    private static final String MANIFEST_FILE_ADDRESS = "META-INF/MANIFEST.MF";
    private static final String ATTRIBUTE_NAME = "Bundle-Name";
    private static final String ATTRIBUTE_VERSION = "Bundle-Version";
    private static final String ATTRIBUTE_TIMESTAMP = "Build-Timestamp";
    private final String name;
    private final String version;
    private final String timestamp;

    private PluginInfo() {
        this("", "", "");
    }

    private PluginInfo(String name, String version, String timestamp) {
        this.name = name;
        this.version = version;
        this.timestamp = timestamp;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    static PluginInfo getInstance() {
        Manifest manifest = new Manifest();
        try {
            manifest.read(Thread.currentThread().getContextClassLoader().getResourceAsStream(MANIFEST_FILE_ADDRESS));
            Attributes manifestAttributes = manifest.getMainAttributes();
            return new PluginInfo(manifestAttributes.getValue(ATTRIBUTE_NAME), manifestAttributes.getValue(ATTRIBUTE_VERSION), manifestAttributes.getValue(ATTRIBUTE_TIMESTAMP));
        }
        catch (IOException | IllegalArgumentException e) {
            return new PluginInfo();
        }
    }

    static PluginInfo getInstance(String name, String version) {
        return new PluginInfo(name, version, LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME));
    }
}

