/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.maven;

import com.exadel.aem.toolkit.plugin.exceptions.PluginException;
import com.exadel.aem.toolkit.plugin.maven.JvmHelper;
import com.exadel.aem.toolkit.plugin.maven.PluginInfo;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.maven.PluginSettings;
import com.exadel.aem.toolkit.plugin.sources.ComponentSource;
import com.exadel.aem.toolkit.plugin.writers.PackageWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="aem-authoring", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE)
public class PluginMojo
extends AbstractMojo {
    private static final Logger LOG = LoggerFactory.getLogger((String)"Exadel Toolbox Authoring Kit");
    static final String PLUGIN_GOAL = "aem-authoring";
    private static final String PLUGIN_ARTIFACT_ID = "etoolbox-authoring-kit-plugin";
    private static final String PLUGIN_GROUP = "com.exadel.etoolbox";
    private static final String PROJECT_TYPE_PACKAGE = "content-package";
    private static final String CONFIG_KEY_CLASSPATH_ELEMENTS = "classpathElements";
    private static final String CONFIG_KEY_PATH_BASE = "componentsPathBase";
    private static final String CONFIG_KEY_REFERENCE_BASE = "componentsReferenceBase";
    private static final String CONFIG_KEY_TERMINATE_ON = "terminateOn";
    private static final String DEPENDENCY_RESOLUTION_EXCEPTION_MESSAGE = "Could not resolve dependencies of project %s: %s";
    private static final String PLUGIN_EXECUTION_EXCEPTION_MESSAGE = "%s in module %s: %s";
    private static final String PLUGIN_COMPLETION_MESSAGE = "Execution completed.";
    private static final String PLUGIN_COMPLETION_STATISTICS_MESSAGE = "Execution completed. {} component(-s) processed.";
    private static final String PATTERN_COLOR_CODE = "[^A-Za-z0-0]\\[[0-9;]*m";
    private static final String PATTERN_LOG_LEVEL = "^\\s*\\[[A-Z]+]\\s+";
    private static final Pattern PATTERN_SPLITTER = Pattern.compile(",");
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${plugin.artifacts}", readonly=true)
    private List<Artifact> pluginDependencies;
    @Parameter(property="classpathElements", readonly=true)
    private String classpathElements;
    @Parameter(property="componentsPathBase", readonly=true)
    private String componentsPathBase;
    @Parameter(property="componentsReferenceBase", readonly=true)
    private String componentsReferenceBase;
    @Parameter(defaultValue="java.io.IOException", property="terminateOn", readonly=true)
    private String terminateOn;

    public void execute() throws MojoExecutionException {
        if (JvmHelper.shouldRelaunch(this.toolchainManager, this.session)) {
            String toolchainJavaExec = JvmHelper.getJavaExecutable(this.toolchainManager, this.session);
            LOG.info("Current JVM is {}. Will switch to {}", (Object)JvmHelper.getJavaHome(), (Object)JvmHelper.getJavaHome(toolchainJavaExec));
            this.fork(toolchainJavaExec);
            return;
        }
        PluginSettings.Builder settingsBuilder = PluginSettings.builder().terminateOn(this.terminateOn).defaultPathBase(this.componentsPathBase);
        this.populateReferenceEntries(settingsBuilder);
        PluginSettings pluginSettings = settingsBuilder.build();
        PluginRuntime.contextBuilder().classPathElements(this.getClasspathElements()).settings(pluginSettings).build();
        int processedCount = 0;
        try (PackageWriter packageWriter = PackageWriter.forMavenProject(this.project);){
            packageWriter.writeInfo(PluginInfo.getInstance());
            for (ComponentSource component : PluginRuntime.context().getReflection().getComponents(this.componentsReferenceBase)) {
                processedCount += packageWriter.write(component) ? 1 : 0;
            }
        }
        catch (PluginException e) {
            throw new MojoExecutionException(String.format(PLUGIN_EXECUTION_EXCEPTION_MESSAGE, e.getCause() != null ? e.getCause().getClass().getSimpleName() : e.getClass().getSimpleName(), this.project.getBuild().getFinalName(), e.getMessage()), (Exception)e);
        }
        PluginRuntime.close();
        if (processedCount > 0) {
            LOG.info(PLUGIN_COMPLETION_STATISTICS_MESSAGE, (Object)processedCount);
        } else {
            LOG.info(PLUGIN_COMPLETION_MESSAGE);
        }
    }

    private void fork(String executable) throws MojoExecutionException {
        Commandline commandline = JvmHelper.commandLine().executable(executable).directory(this.project.getFile().getParent()).pluginCommand(String.join((CharSequence)":", PLUGIN_GROUP, PLUGIN_ARTIFACT_ID, PLUGIN_GOAL)).argument(CONFIG_KEY_CLASSPATH_ELEMENTS, String.join((CharSequence)",", this.getClasspathElements())).argument(CONFIG_KEY_PATH_BASE, this.componentsPathBase).argument(CONFIG_KEY_REFERENCE_BASE, this.componentsReferenceBase).argument(CONFIG_KEY_TERMINATE_ON, this.terminateOn).build();
        LOG.info("Relaunching plugin with {}", (Object)commandline);
        try {
            CommandLineUtils.executeCommandLine((Commandline)commandline, line -> PluginMojo.relayLogLine(arg_0 -> ((Logger)LOG).info(arg_0), line), line -> PluginMojo.relayLogLine(arg_0 -> ((Logger)LOG).error(arg_0), line));
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Could not relaunch plugin process", (Exception)((Object)e));
        }
    }

    private List<String> getClasspathElements() throws MojoExecutionException {
        HashSet result;
        try {
            result = new HashSet(this.project.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(String.format(DEPENDENCY_RESOLUTION_EXCEPTION_MESSAGE, this.project.getBuild().getFinalName(), e.getMessage()), (Exception)((Object)e));
        }
        if (StringUtils.isNotBlank((CharSequence)this.classpathElements)) {
            PATTERN_SPLITTER.splitAsStream(this.classpathElements).filter(StringUtils::isNotBlank).map(String::trim).forEach(result::add);
        }
        this.pluginDependencies.stream().findFirst().ifPresent(d -> result.add(d.getFile().getPath()));
        return new ArrayList<String>(result);
    }

    private void populateReferenceEntries(PluginSettings.Builder builder) {
        List contentPackages = this.session.getProjectDependencyGraph().getAllProjects().stream().filter(p -> StringUtils.equals((CharSequence)p.getPackaging(), (CharSequence)PROJECT_TYPE_PACKAGE)).collect(Collectors.toList());
        for (MavenProject contentPackage : contentPackages) {
            Plugin pluginDefinition = contentPackage.getBuildPlugins().stream().filter(plugin -> PLUGIN_ARTIFACT_ID.equals(plugin.getArtifactId())).findFirst().orElse(null);
            if (pluginDefinition == null) continue;
            Optional.ofNullable(pluginDefinition.getConfiguration()).filter(Xpp3Dom.class::isInstance).map(Xpp3Dom.class::cast).ifPresent(config -> this.populateReferenceEntry((Xpp3Dom)config, builder));
            pluginDefinition.getExecutions().stream().map(ConfigurationContainer::getConfiguration).filter(Xpp3Dom.class::isInstance).map(Xpp3Dom.class::cast).forEach(config -> this.populateReferenceEntry((Xpp3Dom)config, builder));
        }
    }

    private void populateReferenceEntry(Xpp3Dom config, PluginSettings.Builder builder) {
        String pathBase = Optional.ofNullable(config.getChild(CONFIG_KEY_PATH_BASE)).map(Xpp3Dom::getValue).orElse(null);
        String referenceBase = Optional.ofNullable(config.getChild(CONFIG_KEY_REFERENCE_BASE)).map(Xpp3Dom::getValue).orElse(null);
        builder.referenceEntry(pathBase, referenceBase);
    }

    private static void relayLogLine(Consumer<String> logger, String line) {
        String effectiveLine = RegExUtils.removePattern((String)line, (String)PATTERN_LOG_LEVEL);
        if (StringUtils.isEmpty((CharSequence)(effectiveLine = RegExUtils.removePattern((String)effectiveLine, (String)PATTERN_COLOR_CODE)))) {
            return;
        }
        logger.accept(effectiveLine.trim());
    }
}

