/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.maven;

import com.exadel.aem.toolkit.plugin.utils.ClassUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class PluginSettings {
    public static final PluginSettings EMPTY = new PluginSettings();
    private static final int HASH_SEED = 7;
    private static final int HASH_FACTOR = 31;
    private String defaultPathBase;
    private Set<ReferenceEntry> referenceEntries;
    private String terminateOn;

    PluginSettings() {
    }

    public String getPathBase(Class<?> component) {
        if (this.referenceEntries == null) {
            return StringUtils.defaultString((String)this.defaultPathBase);
        }
        String matchedPathBase = this.referenceEntries.stream().filter(entry -> entry.matches(component)).map(ReferenceEntry::getPathBase).findFirst().orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)matchedPathBase)) {
            return matchedPathBase;
        }
        return StringUtils.defaultString((String)this.defaultPathBase);
    }

    public String getTerminateOnRule() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.terminateOn, (CharSequence)"none");
    }

    static Builder builder() {
        return new Builder();
    }

    private static class ReferenceEntry {
        private final String pathBase;
        private final String referenceBase;

        ReferenceEntry(String pathBase, String referenceBase) {
            this.pathBase = pathBase;
            this.referenceBase = referenceBase;
        }

        public String getPathBase() {
            return StringUtils.defaultString((String)this.pathBase);
        }

        public boolean matches(Class<?> component) {
            return ClassUtil.matchesReference(component, this.referenceBase);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ReferenceEntry that = (ReferenceEntry)other;
            return new EqualsBuilder().append((Object)this.pathBase, (Object)that.pathBase).append((Object)this.referenceBase, (Object)that.referenceBase).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(7, 31).append((Object)this.pathBase).append((Object)this.referenceBase).toHashCode();
        }
    }

    static class Builder {
        private String pathBase;
        private Set<ReferenceEntry> referenceEntries;
        private String terminateOn;

        Builder() {
        }

        public Builder defaultPathBase(String value) {
            this.pathBase = value;
            return this;
        }

        public Builder referenceEntry(String pathValue, String referenceValue) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{pathValue, referenceValue})) {
                return this;
            }
            if (this.referenceEntries == null) {
                this.referenceEntries = new LinkedHashSet<ReferenceEntry>();
            }
            this.referenceEntries.add(new ReferenceEntry(pathValue, referenceValue));
            return this;
        }

        public Builder terminateOn(String value) {
            this.terminateOn = value;
            return this;
        }

        public PluginSettings build() {
            PluginSettings result = new PluginSettings();
            result.defaultPathBase = this.pathBase;
            result.referenceEntries = this.referenceEntries;
            result.terminateOn = this.terminateOn;
            return result;
        }
    }
}

