/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.metadata;

import com.exadel.aem.toolkit.api.markers._Default;
import com.exadel.aem.toolkit.plugin.exceptions.ReflectionException;
import com.exadel.aem.toolkit.plugin.maven.PluginRuntime;
import com.exadel.aem.toolkit.plugin.metadata.InvocationResult;
import com.exadel.aem.toolkit.plugin.metadata.Metadata;
import com.exadel.aem.toolkit.plugin.metadata.MethodBackedProperty;
import com.exadel.aem.toolkit.plugin.metadata.Property;
import com.exadel.aem.toolkit.plugin.metadata.PropertyPath;
import com.exadel.aem.toolkit.plugin.metadata.PropertyPathElement;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

class MetadataHandler<T>
implements InvocationHandler {
    private static final String METHOD_ANNOTATION_TYPE = "annotationType";
    private static final String METHOD_EQUALS = "equals";
    private static final String METHOD_FOR_EACH = "forEach";
    private static final String METHOD_GET = "getValue";
    private static final String METHOD_GET_ANNOTATION = "getAnnotation";
    private static final String METHOD_GET_ANY_ANNOTATION = "getAnyAnnotation";
    private static final String METHOD_GET_PROPERTY = "getProperty";
    private static final String METHOD_HAS_PROPERTY = "hasProperty";
    private static final String METHOD_HASH_CODE = "hashCode";
    private static final String METHOD_ITERATOR = "iterator";
    private static final String METHOD_PUT = "putValue";
    private static final String METHOD_SPLITERATOR = "spliterator";
    private static final String METHOD_STREAM = "stream";
    private static final String METHOD_TO_STRING = "toString";
    private static final String METHOD_UNSET = "unsetValue";
    private static final String FIELD_SOURCE = "__source";
    private static final String FIELD_PROPERTIES = "__properties";
    private static final String OPENING_SQUARE = "[";
    private static final String CLOSING_SQUARE = "]";
    private static final String TYPE_EXCEPTION_TEMPLATE = "Trying to set a value of type %s to property %s";
    private static final String VALUE_EXCEPTION_TEMPLATE = "Invalid value address %s";
    private static final int HASH_INITIAL_NUMBER = 17;
    private static final int HASH_MULTIPLIER = 37;
    private final T source;
    private final Class<?> type;
    private final Map<String, Object> properties;

    MetadataHandler(Class<T> type, Map<String, Object> properties) {
        this(null, type, properties);
    }

    MetadataHandler(T source, Map<String, Object> properties) {
        this(source, source instanceof Annotation ? ((Annotation)source).annotationType() : source.getClass(), properties);
    }

    private MetadataHandler(T source, Class<?> type, Map<String, Object> properties) {
        this.source = source;
        this.type = type;
        this.properties = new HashMap<String, Object>();
        if (properties != null) {
            properties.forEach((key, value) -> this.putValue(PropertyPath.parse(key), value));
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        InvocationResult invocation = this.tryInvokeStandardMember(method, args);
        if (invocation.isDone()) {
            return invocation.getResult();
        }
        invocation = this.tryInvokeMetadataMember(method, args);
        if (invocation.isDone()) {
            return invocation.getResult();
        }
        return this.getProperty(method.getName(), method.getName(), true, true).getValue();
    }

    private InvocationResult tryInvokeStandardMember(Method method, Object[] args) {
        if (method.getName().equals(METHOD_ANNOTATION_TYPE)) {
            return InvocationResult.done(this.type);
        }
        if (method.getName().equals(METHOD_EQUALS) && ArrayUtils.isNotEmpty((Object[])args)) {
            return InvocationResult.done(this.equals(args[0]));
        }
        if (method.getName().equals(METHOD_HASH_CODE)) {
            return InvocationResult.done(this.hashCode());
        }
        if (method.getName().equals(METHOD_TO_STRING)) {
            return InvocationResult.done(this.toString());
        }
        return InvocationResult.NOT_DONE;
    }

    private InvocationResult tryInvokeMetadataMember(Method method, Object[] args) {
        return Stream.of(this::tryInvokeGetAnnotation, this::tryInvokeGetAnyAnnotation, this::tryInvokeHasProperty, this::tryInvokeGetValue, this::tryInvokeGetProperty, this::tryInvokePutValue, this::tryInvokeUnsetValue, this::tryInvokeIterator, this::tryInvokeForEach, this::tryInvokeSpliterator, this::tryInvokeStream).map(func -> (InvocationResult)func.apply(method, args)).filter(InvocationResult::isDone).findFirst().orElse(InvocationResult.NOT_DONE);
    }

    private <A extends Annotation> InvocationResult tryInvokeGetAnnotation(Method method, Object[] args) {
        if (MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_GET_ANNOTATION, Class.class)) {
            Object result = this.type.getDeclaredAnnotation((Class)args[0]);
            return InvocationResult.done(result);
        }
        return InvocationResult.NOT_DONE;
    }

    private <A extends Annotation> InvocationResult tryInvokeGetAnyAnnotation(Method method, Object[] args) {
        if (MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_GET_ANY_ANNOTATION, Class[].class)) {
            for (Class cls : (Class[])args[0]) {
                Object result = this.type.getDeclaredAnnotation(cls);
                if (result == null) continue;
                return InvocationResult.done(result);
            }
            return InvocationResult.done(null);
        }
        return InvocationResult.NOT_DONE;
    }

    private InvocationResult tryInvokeHasProperty(Method method, Object[] args) {
        if (MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_HAS_PROPERTY, String.class)) {
            Property result = this.getProperty((String)args[0], false);
            return InvocationResult.done(result.getValue() != null);
        }
        if (MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_HAS_PROPERTY, PropertyPath.class)) {
            Property result = this.getProperty((PropertyPath)args[0], false);
            return InvocationResult.done(result.getValue() != null);
        }
        return InvocationResult.NOT_DONE;
    }

    private InvocationResult tryInvokeGetValue(Method method, Object[] args) {
        if (MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_GET, String.class)) {
            Property result = this.getProperty((String)args[0], false);
            return InvocationResult.done(result.getValue());
        }
        if (MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_GET, PropertyPath.class)) {
            Property result = this.getProperty((PropertyPath)args[0], false);
            return InvocationResult.done(result.getValue());
        }
        return InvocationResult.NOT_DONE;
    }

    private InvocationResult tryInvokeGetProperty(Method method, Object[] args) {
        if (MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_GET_PROPERTY, String.class)) {
            Property result = this.getProperty((String)args[0], true);
            return InvocationResult.done(result);
        }
        if (MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_GET_PROPERTY, PropertyPath.class)) {
            Property result = this.getProperty((PropertyPath)args[0], true);
            return InvocationResult.done(result);
        }
        return InvocationResult.NOT_DONE;
    }

    private InvocationResult tryInvokePutValue(Method method, Object[] args) {
        if (MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_PUT, String.class, Object.class)) {
            Object result = this.putValue((String)args[0], args[1]);
            return InvocationResult.done(result);
        }
        if (MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_PUT, PropertyPath.class, Object.class)) {
            Object result = this.putValue((PropertyPath)args[0], args[1]);
            return InvocationResult.done(result);
        }
        return InvocationResult.NOT_DONE;
    }

    private InvocationResult tryInvokeUnsetValue(Method method, Object[] args) {
        if (MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_UNSET, String.class)) {
            Object result = this.putValue((String)args[0], null);
            return InvocationResult.done(result);
        }
        return InvocationResult.NOT_DONE;
    }

    private InvocationResult tryInvokeIterator(Method method, Object[] args) {
        if (MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_ITERATOR, new Class[0]) || MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_ITERATOR, Boolean.TYPE, Boolean.TYPE)) {
            Iterator result = this.getIterator(args);
            return InvocationResult.done(result);
        }
        return InvocationResult.NOT_DONE;
    }

    private InvocationResult tryInvokeForEach(Method method, Object[] args) {
        if (MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_FOR_EACH, Consumer.class)) {
            Consumer consumer = (Consumer)args[0];
            new Iterator(false, false).forEachRemaining(consumer);
            return InvocationResult.done(null);
        }
        return InvocationResult.NOT_DONE;
    }

    private InvocationResult tryInvokeSpliterator(Method method, Object[] args) {
        if (MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_SPLITERATOR, new Class[0]) || MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_SPLITERATOR, Boolean.TYPE, Boolean.TYPE)) {
            Spliterator<Property> result = this.getSpliterator(args);
            return InvocationResult.done(result);
        }
        return InvocationResult.NOT_DONE;
    }

    private InvocationResult tryInvokeStream(Method method, Object[] args) {
        if (MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_STREAM, new Class[0]) || MetadataHandler.matchesNameAndArgumentTypes(method, args, METHOD_STREAM, Boolean.TYPE, Boolean.TYPE)) {
            Spliterator<Property> spliterator = this.getSpliterator(args);
            Stream<Property> stream = StreamSupport.stream(spliterator, false);
            return InvocationResult.done(stream);
        }
        return InvocationResult.NOT_DONE;
    }

    private static boolean matchesNameAndArgumentTypes(Method method, Object[] args, String name, Class<?> ... argTypes) {
        if (!StringUtils.equals((CharSequence)method.getName(), (CharSequence)name)) {
            return false;
        }
        if (ArrayUtils.isEmpty((Object[])argTypes)) {
            return true;
        }
        int argsLength = ArrayUtils.getLength((Object)args);
        if (argsLength < argTypes.length) {
            return false;
        }
        for (int i = 0; i < argTypes.length; ++i) {
            if (args[i] != null && ClassUtils.isAssignable(args[i].getClass(), argTypes[i])) continue;
            return false;
        }
        return true;
    }

    private Iterator getIterator(Object[] args) {
        boolean deepRead = false;
        boolean expandArrays = false;
        if (ArrayUtils.isNotEmpty((Object[])args) && args[0] != null && ClassUtils.isAssignable(args[0].getClass(), Boolean.TYPE)) {
            deepRead = (Boolean)args[0];
        }
        if (ArrayUtils.getLength((Object)args) > 1 && args[1] != null && ClassUtils.isAssignable(args[0].getClass(), Boolean.TYPE)) {
            expandArrays = (Boolean)args[1];
        }
        return new Iterator(deepRead, expandArrays);
    }

    private Spliterator<Property> getSpliterator(Object[] args) {
        Iterator iterator = this.getIterator(args);
        return Spliterators.spliteratorUnknownSize(iterator, 0);
    }

    private Property getProperty(String path, boolean throwOnMissing) {
        return this.getProperty(PropertyPath.parse(path), throwOnMissing);
    }

    private Property getProperty(PropertyPath path, boolean throwOnMissing) {
        PropertyPathElement element = path.getElements().remove();
        String name = element.getName();
        if (FIELD_SOURCE.equals(name)) {
            return new Property(name, this.source);
        }
        if (FIELD_PROPERTIES.equals(name)) {
            return new Property(name, this.properties);
        }
        Property result = this.getProperty(path.getPath(), name, throwOnMissing, true);
        if (result.getValue() == null) {
            return result;
        }
        if (result.getType().isArray() && element.hasIndex()) {
            if (element.getIndex() < Array.getLength(result.getValue())) {
                result.setValue(Array.get(result.getValue(), element.getIndex()));
            } else {
                result.setValue(null);
                return result;
            }
        }
        if (result.getComponentType().isAnnotation() && !path.getElements().isEmpty()) {
            return Metadata.from((Annotation)result.getValue()).getProperty(path);
        }
        return result;
    }

    private Property getProperty(String path, String name, boolean throwOnMissingMethod, boolean substituteMissingValue) {
        try {
            Method method = this.type.getDeclaredMethod(name, new Class[0]);
            Object value = MetadataHandler.getDefaultReturnValue(method, substituteMissingValue);
            if (this.source != null) {
                value = method.invoke(this.source, new Object[0]);
            }
            if (this.properties != null && this.properties.containsKey(name)) {
                value = this.properties.get(method.getName());
                value = value != null ? value : MetadataHandler.getDefaultReturnValue(method, substituteMissingValue);
            }
            return new MethodBackedProperty(path, method, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            if (throwOnMissingMethod) {
                PluginRuntime.context().getExceptionHandler().handle((Exception)new ReflectionException(String.format(VALUE_EXCEPTION_TEMPLATE, name), e));
            }
            return Property.EMPTY;
        }
    }

    private static Object getDefaultReturnValue(Method method, boolean createMissingObjects) {
        if (method.getDefaultValue() != null) {
            return method.getDefaultValue();
        }
        if (method.getReturnType().isArray() && createMissingObjects) {
            return Array.newInstance(method.getReturnType().getComponentType(), 0);
        }
        if (method.getReturnType().isAnnotation() && createMissingObjects) {
            return Metadata.from(method.getReturnType());
        }
        if (method.getReturnType().equals(String.class)) {
            return "";
        }
        if (method.getReturnType().equals(Class.class)) {
            return _Default.class;
        }
        if (ClassUtils.primitiveToWrapper(method.getReturnType()).equals(Boolean.class)) {
            return false;
        }
        if (ClassUtils.primitiveToWrapper(method.getReturnType()).equals(Integer.class)) {
            return 0;
        }
        if (ClassUtils.primitiveToWrapper(method.getReturnType()).equals(Long.class)) {
            return 0L;
        }
        if (ClassUtils.primitiveToWrapper(method.getReturnType()).equals(Float.class)) {
            return Float.valueOf(0.0f);
        }
        if (ClassUtils.primitiveToWrapper(method.getReturnType()).equals(Double.class)) {
            return 0.0;
        }
        return null;
    }

    private Object putValue(String path, Object value) {
        return this.putValue(PropertyPath.parse(path), value);
    }

    private Object putValue(PropertyPath path, Object value) {
        boolean mustWriteToArray;
        if (path.getElements().size() > 1) {
            return this.putInTree(path, value);
        }
        PropertyPathElement element = path.getElements().remove();
        Property currentProperty = this.getProperty(path.getPath(), element.getName(), true, false);
        if (Property.EMPTY.equals(currentProperty)) {
            return null;
        }
        boolean bl = mustWriteToArray = currentProperty.getType().isArray() && element.hasIndex();
        if (mustWriteToArray) {
            if (!this.validateValueType(element, path, value, true) || !MetadataHandler.validateArrayBounds(element, path, currentProperty.getValue())) {
                return null;
            }
            Object modifiedValue = MetadataHandler.appendToArrayIfNeeded(currentProperty.getValue(), currentProperty.getComponentType(), element.getIndex());
            this.properties.put(element.getName(), modifiedValue);
            Array.set(modifiedValue, element.getIndex(), value);
            return value;
        }
        if (this.validateValueType(element, path, value)) {
            return this.properties.put(element.getName(), value);
        }
        return null;
    }

    private Object putInTree(PropertyPath path, Object value) {
        Metadata metadata;
        boolean mustWriteToArray;
        PropertyPathElement element = path.getElements().remove();
        Property currentProperty = this.getProperty(path.getPath(), element.getName(), true, false);
        if (Property.EMPTY.equals(currentProperty)) {
            return null;
        }
        Object existingValue = currentProperty.getValue();
        boolean bl = mustWriteToArray = currentProperty.getType().isArray() && element.hasIndex();
        if (mustWriteToArray) {
            if (!this.validateValueType(element, path, currentProperty.getValue(), true) || !MetadataHandler.validateArrayBounds(element, path, currentProperty.getValue())) {
                return null;
            }
            existingValue = MetadataHandler.appendToArrayIfNeeded(currentProperty.getValue(), currentProperty.getComponentType(), element.getIndex());
            this.properties.put(element.getName(), existingValue);
            existingValue = Array.get(existingValue, element.getIndex());
        }
        if (!currentProperty.getComponentType().isAnnotation()) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ReflectionException(String.format(VALUE_EXCEPTION_TEMPLATE, path)));
            return null;
        }
        if (!(existingValue instanceof Metadata)) {
            Metadata metadata2 = metadata = existingValue != null ? Metadata.from((Annotation)existingValue) : (Metadata)Metadata.from(currentProperty.getComponentType());
            if (mustWriteToArray) {
                Array.set(this.properties.get(element.getName()), element.getIndex(), metadata);
            } else {
                this.properties.put(element.getName(), metadata);
            }
        } else {
            metadata = (Metadata)existingValue;
        }
        return metadata.putValue(path, value);
    }

    private static Object appendToArrayIfNeeded(Object source, Class<?> componentType, int index) {
        int sourceLength;
        int n = sourceLength = source == null || !source.getClass().isArray() ? 0 : Array.getLength(source);
        if (index < sourceLength) {
            return source;
        }
        Object newArray = Array.newInstance(componentType, sourceLength + 1);
        for (int i = 0; i < sourceLength; ++i) {
            Array.set(newArray, i, Array.get(source, i));
        }
        if (componentType.isAnnotation()) {
            Array.set(newArray, sourceLength, Metadata.from(componentType));
        }
        return newArray;
    }

    private boolean validateValueType(PropertyPathElement element, PropertyPath path, Object value) {
        return this.validateValueType(element, path, value, false);
    }

    private boolean validateValueType(PropertyPathElement element, PropertyPath path, Object value, boolean lookUpArray) {
        boolean result;
        if (value == null) {
            return true;
        }
        try {
            Method method = this.type.getDeclaredMethod(element.getName(), new Class[0]);
            Class<?> methodType = method.getReturnType();
            if (methodType.isArray() && !value.getClass().isArray() && lookUpArray) {
                methodType = methodType.getComponentType();
            }
            result = ClassUtils.isAssignable(value.getClass(), methodType);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        if (!result) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ReflectionException(String.format(TYPE_EXCEPTION_TEMPLATE, value.getClass().getSimpleName(), path)));
        }
        return result;
    }

    private static boolean validateArrayBounds(PropertyPathElement element, PropertyPath path, Object target) {
        int length;
        int n = length = target == null || !target.getClass().isArray() ? 0 : Array.getLength(target);
        if (element.getIndex() > length) {
            PluginRuntime.context().getExceptionHandler().handle((Exception)new ReflectionException(String.format(VALUE_EXCEPTION_TEMPLATE, path)));
            return false;
        }
        return true;
    }

    private static Object invokeSilently(Method method, Object source) {
        try {
            return method.invoke(source, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    public String toString() {
        if (this.source == null && this.properties.isEmpty()) {
            return String.valueOf(this.type);
        }
        StringBuilder result = new StringBuilder("@").append(this.type.getName()).append("{");
        for (Method method : this.type.getDeclaredMethods()) {
            Object methodValue = this.source != null ? MetadataHandler.invokeSilently(method, this.source) : null;
            methodValue = this.properties.getOrDefault(method.getName(), methodValue);
            boolean isDefaultMethodValue = false;
            if (methodValue == null) {
                methodValue = MetadataHandler.getDefaultReturnValue(method, true);
                isDefaultMethodValue = true;
            }
            result.append(method.getName()).append("=").append(isDefaultMethodValue ? "(default) " : "");
            if (methodValue != null && methodValue.getClass().isArray()) {
                result.append(MetadataHandler.toArrayString(methodValue));
            } else if (methodValue != null && methodValue.getClass().isAnnotation()) {
                result.append(Metadata.from((Annotation)methodValue));
            } else {
                result.append(methodValue);
            }
            result.append(";");
        }
        return StringUtils.stripEnd((String)result.toString(), (String)";") + "}";
    }

    private static String toArrayString(Object array) {
        StringBuilder result = new StringBuilder(OPENING_SQUARE);
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object entry = Array.get(array, i);
            if (entry instanceof Annotation) {
                result.append(Metadata.from((Annotation)entry));
            } else {
                result.append(entry);
            }
            result.append(",");
        }
        return StringUtils.strip((String)result.toString(), (String)",") + CLOSING_SQUARE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metadata)) {
            return false;
        }
        Metadata that = (Metadata)o;
        return new EqualsBuilder().append(this.source, that.getValue(FIELD_SOURCE)).append(this.type, that.annotationType()).append(this.properties, that.getValue(FIELD_PROPERTIES)).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.source).append(this.type).append(this.properties).toHashCode();
    }

    private class Iterator
    implements java.util.Iterator<Property> {
        private final boolean deepRead;
        private final boolean expandArrays;
        private final Queue<Property> properties;

        Iterator(boolean deepRead, boolean expandArrays) {
            this.deepRead = deepRead;
            this.expandArrays = expandArrays;
            this.properties = new LinkedList<Property>();
            this.collect(null, "", this.properties);
        }

        @Override
        public boolean hasNext() {
            return !this.properties.isEmpty();
        }

        @Override
        public Property next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.properties.remove();
        }

        private void collect(Annotation target, String pathPrefix, Queue<Property> collection) {
            Method[] methods;
            for (Method method : methods = target != null ? target.annotationType().getDeclaredMethods() : MetadataHandler.this.type.getDeclaredMethods()) {
                this.collect(target, method, pathPrefix, collection);
            }
        }

        private void collect(Annotation target, Method method, String pathPrefix, Queue<Property> collection) {
            Object value;
            String path = this.joinPathChunks(pathPrefix, method.getName());
            Class<?> propertyType = method.getReturnType();
            Object object = value = target != null ? MetadataHandler.invokeSilently(method, target) : this.invokeInCurrentObjectSilently(method);
            if (value == null) {
                value = MetadataHandler.getDefaultReturnValue(method, true);
            }
            if (this.deepRead && propertyType.isAnnotation()) {
                this.collect((Annotation)value, path, collection);
            } else if (this.expandArrays && propertyType.isArray()) {
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    String indexedPath = path + MetadataHandler.OPENING_SQUARE + i + MetadataHandler.CLOSING_SQUARE;
                    if (this.deepRead && propertyType.getComponentType().isAnnotation()) {
                        this.collect((Annotation)Array.get(value, i), indexedPath, collection);
                        continue;
                    }
                    collection.add(new Property(indexedPath, Array.get(value, i)));
                }
            } else {
                collection.add(new MethodBackedProperty(path, method, value));
            }
        }

        private Object invokeInCurrentObjectSilently(Method method) {
            if (MetadataHandler.this.properties != null && MetadataHandler.this.properties.containsKey(method.getName())) {
                return MetadataHandler.this.properties.get(method.getName());
            }
            return MetadataHandler.this.source != null ? MetadataHandler.invokeSilently(method, MetadataHandler.this.source) : null;
        }

        private String joinPathChunks(String left, String right) {
            return left + (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{left, right}) ? "/" : "") + right;
        }
    }
}

