/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.aem.toolkit.plugin.metadata;

import com.exadel.aem.toolkit.plugin.metadata.PropertyPathElement;
import java.util.LinkedList;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PropertyPath {
    private static final Pattern ORDINAL_PATTERN = Pattern.compile("\\[(\\d+)]$");
    private static final String METHOD_PATTERN = "()";
    private final String path;
    private final Queue<PropertyPathElement> elements;

    private PropertyPath(String path, Queue<PropertyPathElement> elements) {
        this.path = path;
        this.elements = elements;
    }

    public String getPath() {
        return this.path;
    }

    public Queue<PropertyPathElement> getElements() {
        return this.elements;
    }

    public static PropertyPath parse(String path) {
        String[] stringArray;
        String delimiter = PropertyPath.getDelimiter(path);
        String effectivePath = StringUtils.strip((String)path, (String)"/.");
        if (delimiter != null) {
            stringArray = StringUtils.split((String)effectivePath, (String)delimiter);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = effectivePath;
        }
        String[] pathChunks = stringArray;
        LinkedList<PropertyPathElement> elements = new LinkedList<PropertyPathElement>();
        String[] stringArray3 = pathChunks;
        int n = stringArray3.length;
        for (int i = 0; i < n; ++i) {
            String pathChunk;
            String name = pathChunk = stringArray3[i];
            int ordinal = -1;
            Matcher ordinalMatcher = ORDINAL_PATTERN.matcher(name);
            if (ordinalMatcher.find()) {
                name = name.substring(0, ordinalMatcher.start());
                ordinal = Integer.parseInt(ordinalMatcher.group(1));
            }
            if (StringUtils.endsWith((CharSequence)name, (CharSequence)METHOD_PATTERN)) {
                name = StringUtils.substring((String)name, (int)0, (int)(METHOD_PATTERN.length() * -1));
            }
            elements.add(new PropertyPathElement(name, ordinal));
        }
        return new PropertyPath(path, elements);
    }

    private static String getDelimiter(String path) {
        if (StringUtils.lastIndexOf((CharSequence)path, (CharSequence)"/") > 0) {
            return "/";
        }
        if (StringUtils.contains((CharSequence)path, (CharSequence)".")) {
            return ".";
        }
        return null;
    }
}

